/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import toughasnails.api.ITANBlock;
import toughasnails.api.TANBlocks;
import toughasnails.block.BlockRainCollector;
import toughasnails.block.BlockTANCampfire;
import toughasnails.block.BlockTANTemperatureCoil;
import toughasnails.core.ToughAsNails;
import toughasnails.fluids.PurifiedWaterFluid;
import toughasnails.fluids.blocks.BlockPurifiedWaterFluid;
import toughasnails.tileentity.TileEntityTemperatureSpread;
import toughasnails.util.BlockStateUtils;
import toughasnails.util.inventory.CreativeTabTAN;

public class ModBlocks {
    public static void init() {
        TANBlocks.campfire = ModBlocks.registerBlock(new BlockTANCampfire(), "campfire");
        TANBlocks.rain_collector = ModBlocks.registerBlock(new BlockRainCollector(), "rain_collector");
        TANBlocks.temperature_coil = ModBlocks.registerBlock((Block)new BlockTANTemperatureCoil(), "temperature_coil");
        TANBlocks.purified_water_fluid = PurifiedWaterFluid.instance;
        FluidRegistry.addBucketForFluid((Fluid)TANBlocks.purified_water_fluid);
        TANBlocks.purified_water = ModBlocks.registerFluidBlock(TANBlocks.purified_water_fluid, (Block)new BlockPurifiedWaterFluid(TANBlocks.purified_water_fluid), "purified_water");
        GameRegistry.registerTileEntity(TileEntityTemperatureSpread.class, (String)"temperature_spread");
    }

    public static Block registerFluidBlock(Fluid fluid, Block fluidBlock, String name) {
        fluidBlock.setRegistryName(new ResourceLocation("toughasnails", name));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)fluidBlock);
        ToughAsNails.proxy.registerFluidBlockRendering(fluidBlock, name);
        fluid.setBlock(fluidBlock);
        return fluidBlock;
    }

    public static void registerBlockItemModel(Block block, String stateName, int stateMeta) {
        Item item = Item.func_150898_a((Block)block);
        ToughAsNails.proxy.registerItemVariantModel(item, stateName, stateMeta);
    }

    public static Block registerBlock(Block block, String blockName) {
        return ModBlocks.registerBlock(block, blockName, CreativeTabTAN.instance);
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab) {
        return ModBlocks.registerBlock(block, blockName, tab, true);
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab, boolean registerItemModels) {
        Preconditions.checkNotNull((Object)block, (Object)"Cannot register a null block");
        block.func_149663_c(blockName);
        block.func_149647_a(tab);
        if (block instanceof ITANBlock) {
            ITANBlock bopBlock = (ITANBlock)block;
            ModBlocks.registerBlockWithItem(block, blockName, bopBlock.getItemClass());
            ToughAsNails.proxy.registerBlockSided(block);
            IBlockState defaultState = block.func_176223_P();
            if (defaultState == null) {
                defaultState = block.func_176194_O().func_177621_b();
                ToughAsNails.logger.error("Missing default state for " + block.func_149739_a());
            }
            if (registerItemModels) {
                ImmutableSet<IBlockState> presets = BlockStateUtils.getBlockPresets(block);
                if (presets.isEmpty()) {
                    ModBlocks.registerBlockItemModel(block, blockName, 0);
                } else {
                    for (IBlockState state : presets) {
                        String stateName = bopBlock.getStateName(state);
                        int stateMeta = block.func_176201_c(state);
                        ModBlocks.registerBlockItemModel(block, stateName, stateMeta);
                    }
                }
            }
        } else {
            ModBlocks.registerBlockWithItem(block, blockName, ItemBlock.class);
            ModBlocks.registerBlockItemModel(block, blockName, 0);
        }
        return block;
    }

    private static void registerBlockWithItem(Block block, String blockName, Class<? extends ItemBlock> clazz) {
        try {
            Item itemBlock = clazz != null ? (Item)clazz.getConstructor(Block.class).newInstance(block) : null;
            ResourceLocation location = new ResourceLocation("toughasnails", blockName);
            block.setRegistryName(new ResourceLocation("toughasnails", blockName));
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            if (itemBlock != null) {
                itemBlock.setRegistryName(new ResourceLocation("toughasnails", blockName));
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred associating an item block during registration of " + blockName, e);
        }
    }
}

