/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import toughasnails.core.ToughAsNails;

public class ModEntities {
    public static final Map<Integer, String> idToTANEntityName = Maps.newLinkedHashMap();
    private static int nextTANEntityId = 1;

    public static void init() {
    }

    public static int registerTANEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        int tanEntityId = nextTANEntityId++;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("toughasnails", entityName), entityClass, (String)entityName, (int)tanEntityId, (Object)ToughAsNails.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        idToTANEntityName.put(tanEntityId, entityName);
        return tanEntityId;
    }

    public static int registerTANEntityWithSpawnEgg(Class<? extends EntityLiving> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggBackgroundColor, int eggForegroundColor, int spawnWeight, int spawnMin, int spawnMax, EnumCreatureType enumCreatureType, Biome ... entityBiomes) {
        int tanEntityId = ModEntities.registerTANEntity(entityClass, entityName, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("toughasnails", entityName), (int)eggBackgroundColor, (int)eggForegroundColor);
        ModEntities.addSpawn(entityClass, spawnWeight, spawnMin, spawnMax, enumCreatureType, entityBiomes);
        return tanEntityId;
    }

    public static Entity createEntityByID(int tanEntityId, World worldIn) {
        Entity entity = null;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)ToughAsNails.instance);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, tanEntityId);
        if (er != null) {
            Class clazz = er.getEntityClass();
            try {
                if (clazz != null) {
                    entity = (Entity)clazz.getConstructor(World.class).newInstance(worldIn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entity == null) {
            ToughAsNails.logger.warn("Skipping TAN Entity with id " + tanEntityId);
        }
        return entity;
    }

    public static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
        for (Biome biome : biomes) {
            if (biome == null) continue;
            List spawns = biome.func_76747_a(typeOfCreature);
            boolean found = false;
            for (Biome.SpawnListEntry entry : spawns) {
                if (entry.field_76300_b != entityClass) continue;
                entry.field_76292_a = weightedProb;
                entry.field_76301_c = min;
                entry.field_76299_d = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new Biome.SpawnListEntry(entityClass, weightedProb, min, max));
        }
    }
}

