/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.config.json.BlockTemperatureData;
import toughasnails.init.ModConfig;
import toughasnails.temperature.modifier.TemperatureModifier;

public class ObjectProximityModifier
extends TemperatureModifier {
    public ObjectProximityModifier(String id) {
        super(id);
    }

    @Override
    public Temperature applyEnvironmentModifiers(World world, BlockPos pos, Temperature initialTemperature, IModifierMonitor monitor) {
        int temperatureLevel;
        int newTemperatureLevel = temperatureLevel = initialTemperature.getRawValue();
        float blockTemperatureModifier = 0.0f;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    IBlockState state;
                    BlockPos pos2 = pos.func_177982_a(x, y - 1, z);
                    float mod = ObjectProximityModifier.getBlockTemperature(world, pos2, state = world.func_180495_p(pos2));
                    if (!(Math.abs(mod) > Math.abs(blockTemperatureModifier))) continue;
                    blockTemperatureModifier = mod;
                }
            }
        }
        newTemperatureLevel = (int)((float)newTemperatureLevel + blockTemperatureModifier);
        monitor.addEntry(new IModifierMonitor.Context(this.getId(), "Nearby Blocks", initialTemperature, new Temperature(newTemperatureLevel)));
        return new Temperature(newTemperatureLevel);
    }

    public static float getBlockTemperature(World world, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        Biome biome = world.func_180494_b(pos);
        ResourceLocation registryName = state.func_177230_c().getRegistryName();
        if (registryName == null) {
            return 0.0f;
        }
        String blockName = state.func_177230_c().getRegistryName().toString();
        if (ModConfig.blockTemperatureData.containsKey(blockName)) {
            List<BlockTemperatureData> blockTempData = ModConfig.blockTemperatureData.get(blockName);
            for (BlockTemperatureData tempData : blockTempData) {
                if (!tempData.predicate.apply(state)) continue;
                return tempData.blockTemperature;
            }
            return 0.0f;
        }
        if (material == Material.field_151581_o) {
            return ModConfig.materialTemperatureData.fire;
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSpecific() {
        return false;
    }
}

