/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.client.gui;

import com.google.common.collect.Ordering;
import java.util.Collection;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import xzeroair.trinkets.client.gui.TrinketGuiContainer;
import xzeroair.trinkets.util.TrinketsConfig;

public class TrinketInventoryEffectRenderer
extends TrinketGuiContainer {
    protected boolean hasActivePotionEffects;

    public TrinketInventoryEffectRenderer(Container inventorySlotsIn) {
        super(inventorySlotsIn);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateActivePotionEffects();
    }

    protected void updateActivePotionEffects() {
        boolean hasVisibleEffect = false;
        for (PotionEffect potioneffect : this.field_146297_k.field_71439_g.func_70651_bq()) {
            Potion potion = potioneffect.func_188419_a();
            if (!potion.shouldRender(potioneffect)) continue;
            hasVisibleEffect = true;
            break;
        }
        if (this.field_146297_k.field_71439_g.func_70651_bq().isEmpty() || !hasVisibleEffect) {
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.hasActivePotionEffects = false;
        } else {
            this.field_147003_i = MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.PotionShiftEvent((GuiScreen)this)) ? (this.field_146294_l - this.field_146999_f) / 2 : 160 + (this.field_146294_l - this.field_146999_f - 200) / 2;
            this.hasActivePotionEffects = true;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hasActivePotionEffects) {
            this.drawActivePotionEffects();
        }
    }

    private void drawActivePotionEffects() {
        int xPos = TrinketsConfig.CLIENT.GUI.X;
        int yPos = TrinketsConfig.CLIENT.GUI.Y;
        int i = this.field_147003_i - (118 + 16 * TrinketsConfig.SERVER.GUI.guiSlotsRows) + xPos;
        int j = this.field_147009_r;
        int k = 166;
        Collection collection = this.field_146297_k.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            int l = 33;
            if (collection.size() > 5) {
                l = 132 / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                Potion potion = potioneffect.func_188419_a();
                if (!potion.shouldRender(potioneffect)) continue;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
                this.func_73729_b(i, j, 0, 166, 140, 32);
                if (potion.func_76400_d()) {
                    int i1 = potion.func_76392_e();
                    this.func_73729_b(i + 6, j + 7, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                }
                potion.renderInventoryEffect(potioneffect, (Gui)this, i, j, this.field_73735_i);
                if (!potion.shouldRenderInvText(potioneffect)) {
                    j += l;
                    continue;
                }
                String s1 = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                if (potioneffect.func_76458_c() == 1) {
                    s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.2", (Object[])new Object[0]);
                } else if (potioneffect.func_76458_c() == 2) {
                    s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.3", (Object[])new Object[0]);
                } else if (potioneffect.func_76458_c() == 3) {
                    s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.4", (Object[])new Object[0]);
                }
                this.field_146289_q.func_175063_a(s1, (float)(i + 10 + 18), (float)(j + 6), 0xFFFFFF);
                String s = Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                this.field_146289_q.func_175063_a(s, (float)(i + 10 + 18), (float)(j + 6 + 10), 0x7F7F7F);
                j += l;
            }
        }
    }
}

