/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.RaceAttribute.RaceAttribute;
import xzeroair.trinkets.capabilities.TrinketCap.TrinketProvider;
import xzeroair.trinkets.capabilities.sizeCap.ISizeCap;
import xzeroair.trinkets.capabilities.sizeCap.SizeCapPro;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.foods.Dwarf_Stout;
import xzeroair.trinkets.items.foods.Fairy_Food;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class PlayerEventMC {
    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer() != null) {
            EntityPlayer player = event.getEntityPlayer();
            ISizeCap cap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
            boolean client = player.field_70170_p.field_72995_K;
            if (event.getTarget() != null && event.getTarget() instanceof EntityLivingBase && event.getTarget().hasCapability(SizeCapPro.sizeCapability, null)) {
                EntityLivingBase entity = (EntityLivingBase)event.getTarget();
                if (!client) {
                    NetworkHandler.sendPlayerDataTo(entity, cap, (EntityPlayerMP)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        if (TrinketsConfig.SERVER.Food.keep_effects && oldPlayer.func_110140_aT().func_111151_a(RaceAttribute.ENTITY_RACE) != null) {
            AttributeModifier fairyFood = oldPlayer.func_110140_aT().func_111151_a(RaceAttribute.ENTITY_RACE).func_111127_a(Fairy_Food.getUUID());
            AttributeModifier dwarfFood = oldPlayer.func_110140_aT().func_111151_a(RaceAttribute.ENTITY_RACE).func_111127_a(Dwarf_Stout.getUUID());
            if (newPlayer.func_110140_aT().func_111151_a(RaceAttribute.ENTITY_RACE) != null) {
                if (dwarfFood != null) {
                    RaceAttribute.addModifier((EntityLivingBase)newPlayer, 2.0, Dwarf_Stout.getUUID(), 2);
                }
                if (fairyFood != null) {
                    RaceAttribute.addModifier((EntityLivingBase)newPlayer, 1.0, Fairy_Food.getUUID(), 2);
                }
            }
        }
        if (event.isWasDeath() && event.getOriginal().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            IAccessoryInterface cap;
            ISizeCap oldCap = (ISizeCap)event.getOriginal().getCapability(SizeCapPro.sizeCapability, null);
            ISizeCap newCap = (ISizeCap)event.getEntityPlayer().getCapability(SizeCapPro.sizeCapability, null);
            ItemStack stack = null;
            if (TrinketHelper.AccessoryCheck((EntityLivingBase)event.getEntityPlayer(), ModItems.trinkets.TrinketDragonsEye)) {
                stack = TrinketHelper.getAccessory(event.getEntityPlayer(), ModItems.trinkets.TrinketDragonsEye);
            }
            if (TrinketHelper.AccessoryCheck((EntityLivingBase)event.getEntityPlayer(), ModItems.trinkets.TrinketPolarized)) {
                stack = TrinketHelper.getAccessory(event.getEntityPlayer(), ModItems.trinkets.TrinketPolarized);
            }
            if (stack != null && (cap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null)) != null && !event.getEntityPlayer().field_70170_p.field_72995_K) {
                cap.setAbility(false);
                NetworkHandler.sendItemDataTo((EntityLivingBase)event.getEntityPlayer(), stack, cap, true, (EntityPlayerMP)event.getEntityPlayer());
            }
            if (TrinketHelper.AccessoryCheck((EntityLivingBase)event.getOriginal(), ModItems.trinkets.TrinketFairyRing) || TrinketHelper.AccessoryCheck((EntityLivingBase)event.getOriginal(), ModItems.trinkets.TrinketDwarfRing) || !oldCap.getFood().contains("none")) {
                PlayerEventMC.copySizeFrom(oldPlayer, newPlayer);
            }
        }
    }

    public static void copySizeFrom(EntityPlayer original, EntityPlayer newPlayer) {
        ISizeCap oldCap = (ISizeCap)original.getCapability(SizeCapPro.sizeCapability, null);
        ISizeCap newCap = (ISizeCap)newPlayer.getCapability(SizeCapPro.sizeCapability, null);
        if (newCap != null && oldCap != null) {
            newCap.setTrans(oldCap.getTrans());
            newCap.setTarget(oldCap.getTarget());
            newCap.setSize(oldCap.getSize());
            newCap.setFood(oldCap.getFood());
            newCap.setWidth(oldCap.getWidth());
            newCap.setHeight(oldCap.getHeight());
            newCap.setDefaultWidth(oldCap.getDefaultWidth());
            newCap.setDefaultHeight(oldCap.getDefaultHeight());
            newPlayer.eyeHeight = original.eyeHeight;
        }
    }
}

