/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerProvider;
import xzeroair.trinkets.container.TrinketContainerHandler;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class TrinketEventHandler {
    @SubscribeEvent
    public void EntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventEntityJoinWorld(stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
    }

    @SubscribeEvent
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public void PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
        for (int i = 0; i < Trinket.getSlots(); ++i) {
            ItemStack stack = Trinket.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
            IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
            trinket.eventPlayerLogout(stack, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void PlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
        if (event.phase == TickEvent.Phase.END) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventPlayerTick(stack, player);
            }
        }
    }

    @SubscribeEvent
    public void LivingUpdate(LivingEvent.LivingUpdateEvent event) {
    }

    @SubscribeEvent
    public void TargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getTarget();
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventSetAttackTarget(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void experienceDropEvent(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() instanceof EntityPlayer) {
            EntityPlayer player = event.getAttackingPlayer();
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingExperienceDrops(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void ItemDropEvent(LivingDropsEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingDrops(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void deathEvent(LivingDamageEvent event) {
        IAccessoryInterface trinket;
        ItemStack stack;
        int i;
        ITrinketContainerHandler Trinket;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntity();
            Trinket = TrinketHelper.getTrinketHandler(player);
            for (i = 0; i < Trinket.getSlots(); ++i) {
                stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingDamageAttacked(event, stack, (EntityLivingBase)player);
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            Trinket = TrinketHelper.getTrinketHandler(player);
            for (i = 0; i < Trinket.getSlots(); ++i) {
                stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingDamageAttacker(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void HurtEvent(LivingHurtEvent event) {
        IAccessoryInterface trinket;
        ItemStack stack;
        int i;
        ITrinketContainerHandler Trinket;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntity();
            Trinket = TrinketHelper.getTrinketHandler(player);
            for (i = 0; i < Trinket.getSlots(); ++i) {
                stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventPlayerHurt(event, stack, (EntityLivingBase)player);
            }
        }
        if (event.getEntityLiving() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            Trinket = TrinketHelper.getTrinketHandler(player);
            for (i = 0; i < Trinket.getSlots(); ++i) {
                stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingHurt(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ITrinketContainerHandler Trinket;
        if (event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer && (Trinket = TrinketHelper.getTrinketHandler(player = (EntityPlayer)event.getEntityLiving())) != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingJump(stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        EntityPlayer player;
        ITrinketContainerHandler Trinket;
        if (event.getEntityLiving() instanceof EntityPlayer && (Trinket = TrinketHelper.getTrinketHandler(player = (EntityPlayer)event.getEntityLiving())) != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                ItemStack stack = Trinket.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingFall(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K && !event.getEntity().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.dropItemsAt(event.getEntityPlayer(), event.getDrops(), (Entity)event.getEntityPlayer());
        }
    }

    public void dropItemsAt(EntityPlayer player, List<EntityItem> drops, Entity e) {
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
        for (int i = 0; i < Trinket.getSlots(); ++i) {
            if (Trinket.getStackInSlot(i) == null || Trinket.getStackInSlot(i).func_190926_b()) continue;
            EntityItem ei = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, Trinket.getStackInSlot(i).func_77946_l());
            ei.func_174867_a(40);
            float f1 = e.field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f2 = e.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            ei.field_70181_x = 0.2f;
            drops.add(ei);
            Trinket.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void PlayerCloneEvent(PlayerEvent.Clone event) {
        try {
            TrinketContainerHandler bco = (TrinketContainerHandler)event.getOriginal().getCapability(TrinketContainerProvider.containerCap, null);
            NBTTagCompound nbt = bco.serializeNBT();
            TrinketContainerHandler bcn = (TrinketContainerHandler)event.getEntityPlayer().getCapability(TrinketContainerProvider.containerCap, null);
            bcn.deserializeNBT(nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

