/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.base;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.TrinketCap.DefaultTrinketCapability;
import xzeroair.trinkets.capabilities.TrinketCap.TrinketProvider;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.PacketAccessorySync;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;
import xzeroair.trinkets.util.interfaces.IDescriptionInterface;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

public class AccessoryBase
extends Item
implements IsModelLoaded,
IDescriptionInterface,
IAccessoryInterface {
    public AccessoryBase(String name) {
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77625_d(1);
        this.func_77637_a(Trinkets.trinketstab);
        ModItems.trinkets.ITEMS.add(this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new TrinketProvider(new DefaultTrinketCapability(-1, -1, 0, 0, false, false));
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        boolean client = player.field_70170_p.field_72995_K;
        IAccessoryInterface cap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
        if (cap != null) {
            int slot = this.getEquippedSlot(stack, player);
            boolean isTrinket = this.getIsTrinketOrBauble(stack, player).equalsIgnoreCase("Trinket");
            if (player instanceof EntityPlayerMP) {
                NetworkHandler.INSTANCE.sendToAll((IMessage)new PacketAccessorySync((EntityPlayer)((EntityPlayerMP)player), slot, isTrinket, true));
            }
            if (!client) {
                NetworkHandler.sendItemDataTo(player, stack, cap, isTrinket, (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        boolean client = player.field_70170_p.field_72995_K;
        IAccessoryInterface cap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
        boolean isTrinket = this.getIsTrinketOrBauble(stack, player).equalsIgnoreCase("Trinket");
        if (cap != null && cap.wornSlot() >= 0 && player instanceof EntityPlayerMP) {
            NetworkHandler.INSTANCE.sendToAll((IMessage)new PacketAccessorySync((EntityPlayer)((EntityPlayerMP)player), cap.wornSlot(), isTrinket, false));
        }
    }

    @Override
    public String getIsTrinketOrBauble(ItemStack stack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            IBaublesItemHandler baubles2;
            boolean skip = false;
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler((EntityPlayer)player);
            if (Trinket != null) {
                for (int i = 0; i < Trinket.getSlots(); ++i) {
                    if (Trinket.getStackInSlot(i) != stack) continue;
                    skip = true;
                    return "Trinket";
                }
            }
            if (!skip && Loader.isModLoaded((String)"baubles") && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player))) != null) {
                for (int i = 0; i < baubles2.getSlots(); ++i) {
                    if (baubles2.getStackInSlot(i) != stack) continue;
                    return "Bauble";
                }
            }
        }
        return "Else";
    }

    @Override
    public int getEquippedSlot(ItemStack stack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            IBaublesItemHandler baubles2;
            boolean skip = false;
            ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler((EntityPlayer)player);
            if (Trinket != null) {
                for (int i = 0; i < Trinket.getSlots(); ++i) {
                    if (Trinket.getStackInSlot(i) != stack) continue;
                    skip = true;
                    IAccessoryInterface iCap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
                    iCap.setWornSlot(i);
                    return i;
                }
            }
            if (!skip && Loader.isModLoaded((String)"baubles") && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player))) != null) {
                for (int i = 0; i < baubles2.getSlots(); ++i) {
                    if (baubles2.getStackInSlot(i) != stack) continue;
                    IAccessoryInterface iCap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
                    iCap.setWornSlot(i);
                    return i;
                }
            }
        }
        return -1;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (TrinketsConfig.CLIENT.GUI.SLOT.showID) {
            tooltip.add("Currently Equipped in Slot: " + String.valueOf(this.getEquippedSlot(stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g)));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Override
    public boolean playerCanUnequip(ItemStack stack, EntityLivingBase player) {
        if (EnchantmentHelper.func_190938_b((ItemStack)stack) && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != Item.func_150899_d((int)399)) {
            return false;
        }
        if (player instanceof EntityPlayer && ((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            return true;
        }
        return true;
    }

    @Override
    public void registerModels() {
        Trinkets.proxy.registerItemRenderer(this, 0, "inventory");
    }

    @Override
    public boolean hasDiscription(ItemStack stack) {
        return false;
    }
}

