/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.effects;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.TrinketCap.TrinketProvider;
import xzeroair.trinkets.client.particles.ParticleGreed;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.OreTrackingHelper;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class EffectsDragonsEye {
    private static List<BlockPos> targets = new ArrayList<BlockPos>();

    public static List<BlockPos> getTargets() {
        return targets;
    }

    public static void clearTargets() {
        if (!targets.isEmpty()) {
            targets.clear();
        }
    }

    public static void playerTicks(ItemStack stack, EntityLivingBase entity) {
        if (!(!TrinketsConfig.SERVER.DRAGON_EYE.oreFinder) && entity instanceof EntityPlayer) {
            int vd = TrinketsConfig.SERVER.DRAGON_EYE.BLOCKS.DR.C00_VD;
            int hd = TrinketsConfig.SERVER.DRAGON_EYE.BLOCKS.DR.C001_HD;
            int rf = TrinketsConfig.CLIENT.DRAGON_EYE.C00_RR;
            EntityPlayer player = (EntityPlayer)entity;
            IAccessoryInterface iCap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
            if (iCap != null && iCap.oreTarget() != -1 && player.field_70173_aa % rf == 0) {
                int length = TrinketsConfig.SERVER.DRAGON_EYE.BLOCKS.Blocks.length;
                if (iCap.oreTarget() <= length) {
                    if (iCap.oreTarget() > length) {
                        return;
                    }
                    String Type2 = TrinketsConfig.SERVER.DRAGON_EYE.BLOCKS.Blocks[iCap.oreTarget()];
                    if (Type2.contains(":")) {
                        EffectsDragonsEye.BlockDetection(player, player.func_174813_aQ().func_72314_b((double)hd, (double)vd, (double)hd), Type2);
                        if (Type2.contains("minecraft:chest")) {
                            EffectsDragonsEye.chestCartDetect(player, player.func_174813_aQ().func_72314_b((double)hd, (double)vd, (double)hd), Type2);
                        }
                    } else {
                        EffectsDragonsEye.BlockDetectionByOreDictionary(player, player.func_174813_aQ().func_72314_b((double)hd, (double)vd, (double)hd), Type2);
                        if (Type2.equalsIgnoreCase("chest")) {
                            Type2 = "minecraft:chest";
                            EffectsDragonsEye.chestCartDetect(player, player.func_174813_aQ().func_72314_b((double)hd, (double)vd, (double)hd), Type2);
                        }
                    }
                }
            }
        }
    }

    private static void chestCartDetect(EntityPlayer entity, AxisAlignedBB aabb, String ore) {
        List cartList = entity.func_130014_f_().func_72872_a(EntityMinecartChest.class, aabb);
        if (!cartList.isEmpty()) {
            for (EntityMinecartChest chestCart : cartList) {
                EffectsDragonsEye.SpawnParticle(chestCart.func_180425_c(), entity, ore);
            }
        }
    }

    private static void BlockDetectionByOreDictionary(EntityPlayer player, AxisAlignedBB aabb, String ore) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    ItemStack blockStack;
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block.getRegistryName().toString().contentEquals("minecraft:air") || (blockStack = new ItemStack(block, 1, block.func_176201_c(state))) == null || blockStack.func_190926_b()) continue;
                    for (String oreDictionary : OreTrackingHelper.getOreNames(blockStack)) {
                        if (!oreDictionary.contentEquals(ore)) continue;
                        EffectsDragonsEye.SpawnParticleByOreDictionary(pos, player, ore);
                    }
                }
            }
        }
    }

    private static void BlockDetection(EntityPlayer player, AxisAlignedBB aabb, String ore) {
        String oreName = ore.toLowerCase();
        String meta = "";
        String getName = OreTrackingHelper.translateOreName(ore);
        if (oreName.contains("[")) {
            int metaStart = ore.indexOf("[");
            int metaEnd = ore.lastIndexOf("]");
            oreName = ore.substring(0, metaStart);
            meta = ore.substring(metaStart + 1, metaEnd);
        }
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block.getRegistryName().toString().contentEquals("minecraft:air")) continue;
                    if (meta.isEmpty()) {
                        if (!block.getRegistryName().toString().contentEquals(oreName)) continue;
                        EffectsDragonsEye.SpawnParticle(pos, player, ore);
                        continue;
                    }
                    if (!block.getRegistryName().toString().contentEquals(oreName) || meta.isEmpty() || block.func_176201_c(state) != Integer.parseInt(meta)) continue;
                    EffectsDragonsEye.SpawnParticle(pos, player, ore);
                }
            }
        }
    }

    public static void SpawnParticleByOreDictionary(BlockPos pos, EntityPlayer player, String ore) {
        String getName = ore.replace("ore", "");
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        for (Object parseTypeforColor : OreTrackingHelper.oreTypesLoaded()) {
            if (!getName.contains(parseTypeforColor.toString())) continue;
            String color = parseTypeforColor.toString();
            r = TrinketHelper.getColor(color, 0);
            g = TrinketHelper.getColor(color, 1);
            b = TrinketHelper.getColor(color, 2);
        }
        GlStateManager.func_179094_E();
        double X = pos.func_177958_n();
        double Y = pos.func_177956_o();
        double Z = pos.func_177952_p();
        if (TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl) {
            boolean sneaking = TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Sneak.contentEquals("SNEAK") && player.func_70093_af();
            boolean standing = TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Sneak.contentEquals("STAND") && !player.func_70093_af();
            boolean both = TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Sneak.contentEquals("BOTH");
            float volume = (float)player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (volume < 10.0f && (sneaking && !standing || standing && !sneaking || both)) {
                float configVolume = (float)TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Volume / 1000.0f;
                float v = MathHelper.func_76131_a((float)(-volume / 10.0f + 1.0f), (float)0.0f, (float)configVolume);
                if (pos != null) {
                    player.field_70170_p.func_184133_a(player, pos, SoundEvents.field_187525_aO, SoundCategory.RECORDS, v, 1.0f);
                }
            }
        }
        X = Reference.random.nextDouble() + X;
        Y = Reference.random.nextDouble() + Y;
        Z = Reference.random.nextDouble() + Z;
        ParticleGreed effect = new ParticleGreed(player.field_70170_p, X, Y, Z, X, Y, Z, r, g, b);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)effect);
        GlStateManager.func_179121_F();
    }

    public static void SpawnParticle(BlockPos pos, EntityPlayer player, String ore) {
        String getName = OreTrackingHelper.translateOreName(ore);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        for (Object parseTypeforColor : OreTrackingHelper.oreTypesLoaded()) {
            if (!getName.contains(parseTypeforColor.toString())) continue;
            String color = parseTypeforColor.toString();
            r = TrinketHelper.getColor(color, 0);
            g = TrinketHelper.getColor(color, 1);
            b = TrinketHelper.getColor(color, 2);
        }
        GlStateManager.func_179094_E();
        double X = pos.func_177958_n();
        double Y = pos.func_177956_o();
        double Z = pos.func_177952_p();
        if (TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl) {
            boolean sneaking = TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Sneak.contentEquals("SNEAK") && player.func_70093_af();
            boolean standing = TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Sneak.contentEquals("STAND") && !player.func_70093_af();
            boolean both = TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Sneak.contentEquals("BOTH");
            float volume = (float)player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (volume < 10.0f && (sneaking && !standing || standing && !sneaking || both)) {
                float configVolume = (float)TrinketsConfig.CLIENT.DRAGON_EYE.Dragon_Growl_Volume / 1000.0f;
                float v = MathHelper.func_76131_a((float)(-volume / 10.0f + 1.0f), (float)0.0f, (float)configVolume);
                if (pos != null) {
                    player.field_70170_p.func_184133_a(player, pos, SoundEvents.field_187525_aO, SoundCategory.RECORDS, v, 1.0f);
                }
            }
        }
        X = Reference.random.nextDouble() + X;
        Y = Reference.random.nextDouble() + Y;
        Z = Reference.random.nextDouble() + Z;
        ParticleGreed effect = new ParticleGreed(player.field_70170_p, X, Y, Z, X, Y, Z, r, g, b);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)effect);
        GlStateManager.func_179121_F();
    }
}

