/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.effects;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Loader;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.armor.ArmorAttribute;
import xzeroair.trinkets.attributes.attackdamage.DamageAttribute;
import xzeroair.trinkets.attributes.health.HealthAttribute;
import xzeroair.trinkets.attributes.speed.SpeedAttribute;
import xzeroair.trinkets.attributes.toughness.ToughnessAttribute;
import xzeroair.trinkets.capabilities.sizeCap.ISizeCap;
import xzeroair.trinkets.capabilities.sizeCap.SizeCapPro;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.effects.EffectsDwarfRing;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.artemislib.SizeAttribute;
import xzeroair.trinkets.util.compat.firstaid.FirstAidCompat;
import xzeroair.trinkets.util.handlers.ClimbHandler;
import xzeroair.trinkets.util.handlers.SizeHandler;
import xzeroair.trinkets.util.helpers.CallHelper;

public class EffectsFairyRing {
    private static UUID uuid = UUID.fromString("c1a329f8-2a05-4e0d-8099-cbe41485d0f0");
    static ISizeCap cap = null;

    public static UUID getUUID() {
        return uuid;
    }

    public static void FairyTicks(EntityPlayer player) {
        cap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
        if (cap != null && !TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketDwarfRing)) {
            if (cap.getTarget() != 25) {
                cap.setTarget(25);
            }
            if (cap.getTrans()) {
                EntityBoat boat;
                if (cap.getSize() == cap.getTarget()) {
                    if (TrinketsConfig.SERVER.FAIRY_RING.health) {
                        HealthAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.FAIRY_RING.health_amount, uuid, 2);
                    } else {
                        HealthAttribute.removeModifier((EntityLivingBase)player, uuid);
                    }
                    if (TrinketsConfig.SERVER.FAIRY_RING.damage) {
                        DamageAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.FAIRY_RING.damage_amount, uuid, 2);
                    } else {
                        DamageAttribute.removeModifier((EntityLivingBase)player, uuid);
                    }
                    if (TrinketsConfig.SERVER.FAIRY_RING.armor) {
                        ArmorAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.FAIRY_RING.armor_amount, uuid, 2);
                    } else {
                        ArmorAttribute.removeModifier((EntityLivingBase)player, uuid);
                    }
                    if (TrinketsConfig.SERVER.FAIRY_RING.toughness) {
                        ToughnessAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.FAIRY_RING.toughness_amount, uuid, 2);
                    } else {
                        ToughnessAttribute.removeModifier((EntityLivingBase)player, uuid);
                    }
                    if (TrinketsConfig.SERVER.FAIRY_RING.speed) {
                        SpeedAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.FAIRY_RING.speed_amount, uuid, 0);
                    } else {
                        SpeedAttribute.removeModifier((EntityLivingBase)player, uuid);
                    }
                    if (TrinketsConfig.SERVER.FAIRY_RING.creative_flight && !player.func_184812_l_() && !player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = true;
                        if (TrinketsConfig.SERVER.FAIRY_RING.creative_flight_speed && player.field_70170_p.field_72995_K) {
                            player.field_71075_bZ.func_75092_a((float)TrinketsConfig.SERVER.FAIRY_RING.flight_speed);
                        }
                    }
                    if (TrinketsConfig.SERVER.FAIRY_RING.step_height) {
                        float step = player.field_70138_W;
                        float f = 0.25f;
                        if (step != 0.25f && !(step > 0.6f) && !player.func_184812_l_()) {
                            player.field_70138_W = 0.25f;
                        }
                    }
                    if (TrinketsConfig.SERVER.FAIRY_RING.climbing && !player.field_71075_bZ.field_75100_b) {
                        EnumFacing facing = player.func_174811_aO();
                        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        IBlockState state = player.field_70170_p.func_180495_p(pos.func_177982_a(0, 0, 0).func_177972_a(facing));
                        Block block = state.func_177230_c();
                        boolean canPass = block.func_176205_b((IBlockAccess)player.field_70170_p, pos.func_177972_a(facing));
                        if (!player.field_70122_E && player.field_70123_F && ClimbHandler.Climb(player)) {
                            if (!player.func_70093_af()) {
                                player.field_70181_x = 0.1f;
                            }
                            if (player.func_70093_af()) {
                                player.field_70181_x = 0.0;
                            }
                        }
                    }
                    if (!TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketDwarfRing)) {
                        if (Loader.isModLoaded((String)"artemislib") && TrinketsConfig.compat.artemislib) {
                            SizeAttribute.addModifier((EntityLivingBase)player, -0.75, -0.75, 0);
                        } else {
                            if (Loader.isModLoaded((String)"artemislib") && !TrinketsConfig.compat.artemislib) {
                                SizeAttribute.removeModifier((EntityLivingBase)player);
                            }
                            SizeHandler.setSize((EntityLivingBase)player, cap);
                        }
                    }
                }
                if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityBoat && (boat = (EntityBoat)player.func_184187_bx()).func_184179_bs() == player) {
                    player.func_184210_p();
                }
            }
        }
    }

    public static void FairyFall(LivingFallEvent event, EntityPlayer player) {
        if (cap != null) {
            // empty if block
        }
    }

    public static void FairyJump(EntityLivingBase player) {
        if (cap != null) {
            player.field_70181_x *= 0.5;
        }
    }

    public static void FairyEquip(ItemStack stack, EntityLivingBase player) {
        cap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
        EffectsDwarfRing.DwarfUnequip(null, player);
        if (TrinketsConfig.SERVER.FAIRY_RING.health) {
            HealthAttribute.addModifier(player, TrinketsConfig.SERVER.FAIRY_RING.health_amount, uuid, 2);
            if (Loader.isModLoaded((String)"firstaid")) {
                FirstAidCompat.resetHP(player);
            }
        } else {
            HealthAttribute.removeModifier(player, uuid);
        }
        if (TrinketsConfig.SERVER.FAIRY_RING.damage) {
            DamageAttribute.addModifier(player, TrinketsConfig.SERVER.FAIRY_RING.damage_amount, uuid, 2);
        } else {
            DamageAttribute.removeModifier(player, uuid);
        }
        if (TrinketsConfig.SERVER.FAIRY_RING.armor) {
            ArmorAttribute.addModifier(player, TrinketsConfig.SERVER.FAIRY_RING.armor_amount, uuid, 2);
        } else {
            ArmorAttribute.removeModifier(player, uuid);
        }
        if (TrinketsConfig.SERVER.FAIRY_RING.toughness) {
            ToughnessAttribute.addModifier(player, TrinketsConfig.SERVER.FAIRY_RING.toughness_amount, uuid, 2);
        } else {
            ToughnessAttribute.removeModifier(player, uuid);
        }
        if (TrinketsConfig.SERVER.FAIRY_RING.speed) {
            SpeedAttribute.addModifier(player, TrinketsConfig.SERVER.FAIRY_RING.speed_amount, uuid, 2);
        } else {
            SpeedAttribute.removeModifier(player, uuid);
        }
        if (Loader.isModLoaded((String)"artemislib")) {
            SizeAttribute.removeModifier(player);
        }
    }

    public static void FairyUnequip(ItemStack stack, EntityLivingBase player) {
        EntityPlayer Player;
        if (TrinketsConfig.SERVER.FAIRY_RING.creative_flight && player instanceof EntityPlayer && !(Player = (EntityPlayer)player).func_184812_l_()) {
            Player.field_71075_bZ.field_75100_b = false;
            Player.field_71075_bZ.field_75101_c = false;
            if (TrinketsConfig.SERVER.FAIRY_RING.creative_flight_speed && Player.field_71075_bZ.func_75093_a() != 0.05f) {
                Player.field_71075_bZ.func_75092_a(0.05f);
            }
        }
        if (player.field_70138_W != 0.6f && TrinketsConfig.SERVER.FAIRY_RING.step_height) {
            player.field_70138_W = 0.6f;
        }
        if (Loader.isModLoaded((String)"artemislib")) {
            SizeAttribute.removeModifier(player);
        }
        HealthAttribute.removeModifier(player, uuid);
        DamageAttribute.removeModifier(player, uuid);
        ToughnessAttribute.removeModifier(player, uuid);
        ArmorAttribute.removeModifier(player, uuid);
        SpeedAttribute.removeModifier(player, uuid);
    }

    public static void FairyLogIn(EntityLivingBase player, ItemStack stack) {
        if (Loader.isModLoaded((String)"firstaid")) {
            FirstAidCompat.resetHP(player);
        }
    }

    public static void FairyLogout(EntityLivingBase player, ItemStack stack) {
        if (cap != null) {
            HealthAttribute.removeModifier(player, uuid);
            DamageAttribute.removeModifier(player, uuid);
            ToughnessAttribute.removeModifier(player, uuid);
            ArmorAttribute.removeModifier(player, uuid);
            SpeedAttribute.removeModifier(player, uuid);
        }
    }

    public static void renderFairy(EntityPlayer player, float partialTicks, ISizeCap cap) {
        ModelBase wings = CallHelper.getModel("wings");
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        if (cap != null) {
            float size = (float)cap.getSize() / 1000.0f;
            float scale = MathHelper.func_76131_a((float)(0.1f - size), (float)0.0f, (float)0.06f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)4.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.02f, (float)(-(scale - 0.1f)), (float)-0.05f);
            if (player.func_190630_a(EntityEquipmentSlot.CHEST)) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.08f);
                GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
            }
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (player.func_70051_ag()) {
                GlStateManager.func_179114_b((float)14.323944f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            wings.func_78088_a((Entity)player, player.field_184619_aG, player.field_70721_aZ, (float)player.field_70173_aa, player.field_70177_z, player.field_70125_A, 1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public static void FairyFOV(EntityPlayer player) {
        if (cap != null) {
            // empty if block
        }
    }
}

