/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.items.effects.EffectsDamageShield;
import xzeroair.trinkets.util.TrinketsConfig;

public class TrinketDamageShield
extends AccessoryBase {
    protected final UUID uuid = UUID.fromString("c0885371-20dd-4c56-86eb-78f24d9fe777");
    protected ResourceLocation background = null;
    protected boolean hasResist = false;

    public TrinketDamageShield(String name) {
        super(name);
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        if (!player.func_70644_a(MobEffects.field_76429_m)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 0, false, false));
            this.hasResist = false;
        }
        if (player.func_70644_a(MobEffects.field_76429_m)) {
            int dur = player.func_70660_b(MobEffects.field_76429_m).func_76459_b();
            int amp = player.func_70660_b(MobEffects.field_76429_m).func_76458_c();
            if (dur < 200 && amp <= 0 && !this.hasResist) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 0, false, false));
                this.hasResist = false;
            }
            if (dur > 200 && amp < 2 && !this.hasResist) {
                player.func_70660_b(MobEffects.field_76429_m).func_76452_a(new PotionEffect(MobEffects.field_76429_m, dur + 1, amp + 1, false, false));
                this.hasResist = true;
            }
        }
    }

    @Override
    public void eventPlayerHurt(LivingHurtEvent event, ItemStack stack, EntityLivingBase player) {
        EffectsDamageShield.eventPlayerHurt(event, stack, player);
    }

    @Override
    public void eventLivingDamageAttacked(LivingDamageEvent event, ItemStack stack, EntityLivingBase player) {
        EffectsDamageShield.eventLivingDamageAttacked(event, stack, player);
    }

    @Override
    public boolean playerCanEquip(ItemStack stack, EntityLivingBase player) {
        if (TrinketHelper.AccessoryCheck(player, stack.func_77973_b())) {
            return false;
        }
        return super.playerCanEquip(stack, player);
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
        super.playerEquipped(stack, player);
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!TrinketHelper.AccessoryCheck(player, stack.func_77973_b())) {
            player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
            if (player.func_70644_a(MobEffects.field_76429_m)) {
                player.func_184596_c(MobEffects.field_76429_m);
                this.hasResist = false;
            }
        }
        super.playerUnequipped(stack, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playerRender(ItemStack stack, EntityLivingBase player, float partialTicks, boolean isBauble) {
        if (!TrinketsConfig.CLIENT.DAMAGE_SHIELD.doRender) {
            return;
        }
        float scale = 0.2f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.15f, (float)-0.22f, (float)0.14f);
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.24f, (float)-0.07f);
            GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (player.func_190630_a(EntityEquipmentSlot.CHEST)) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.06f);
        }
        GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.func_190903_i(), ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
        if (player.func_110124_au().toString().contentEquals("7f184d63-9f9c-47a7-be03-8382145fb2c2") || player.func_110124_au().toString().contentEquals("cdfccefb-1a2e-4fb8-a3b5-041da27fde61")) {
            this.background = new ResourceLocation("xat:textures/awesomesauce/damage_shield.png");
            GlStateManager.func_179094_E();
            if (player.func_190630_a(EntityEquipmentSlot.CHEST)) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.07f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.95f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.background);
            float size = 0.165f;
            TrinketDamageShield.Draw(0.065, 0.14, 0.8, 0, 0, 0.165f, 0.165f, 6.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public static void Draw(double x, double y, double z, int texX, int texY, float width, float height, float scale, float r, float g, float b, float a) {
        GlStateManager.func_179094_E();
        int l1 = 240;
        boolean l2 = false;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buffer = tes.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(x + 0.0, y + (double)height, z).func_187315_a((double)((float)(texX + 0) * scale), (double)(((float)texY + height) * scale)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x + (double)width, y + (double)height, z).func_187315_a((double)(((float)texX + width) * scale), (double)(((float)texY + height) * scale)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x + (double)width, y + 0.0, z).func_187315_a((double)(((float)texX + width) * scale), (double)((float)(texY + 0) * scale)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, z).func_187315_a((double)((float)(texX + 0) * scale), (double)((float)(texY + 0) * scale)).func_181666_a(r, g, b, a).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketsConfig.SERVER.DAMAGE_SHIELD.enabled;
    }

    @Override
    public boolean hasDiscription(ItemStack stack) {
        return true;
    }
}

