/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.sizeCap.ISizeCap;
import xzeroair.trinkets.capabilities.sizeCap.SizeCapPro;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.items.effects.EffectsFairyRing;
import xzeroair.trinkets.items.trinkets.TrinketDwarfRing;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.util.TrinketsConfig;

public class TrinketFairyRing
extends AccessoryBase {
    public TrinketFairyRing(String name) {
        super(name);
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        ISizeCap cap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
        if (cap != null && !cap.getFood().contains("fairy_dew")) {
            EffectsFairyRing.FairyTicks(player);
        }
    }

    @Override
    public void eventLivingJump(ItemStack stack, EntityLivingBase player) {
        ISizeCap cap;
        if (TrinketsConfig.SERVER.FAIRY_RING.step_height && (cap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null)) != null && !cap.getFood().contains("fairy_dew")) {
            EffectsFairyRing.FairyJump(player);
        }
    }

    @Override
    public void eventEntityJoinWorld(ItemStack stack, EntityLivingBase player) {
        ISizeCap cap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
        if (cap != null) {
            EffectsFairyRing.FairyLogIn(player, stack);
        }
    }

    @Override
    public void eventPlayerLogout(ItemStack stack, EntityLivingBase player) {
        ISizeCap cap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
        if (cap != null && !cap.getFood().contains("fairy_dew")) {
            EffectsFairyRing.FairyLogout(player, stack);
        }
    }

    @Override
    public boolean playerCanEquip(ItemStack stack, EntityLivingBase player) {
        if (TrinketHelper.AccessoryCheck(player, stack.func_77973_b()) || TrinketHelper.AccessoryCheck(player, ModItems.trinkets.TrinketDwarfRing)) {
            return false;
        }
        return super.playerCanEquip(stack, player);
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
        super.playerEquipped(stack, player);
        boolean client = player.field_70170_p.field_72995_K;
        ISizeCap playerCap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
        if (playerCap != null) {
            if (player instanceof EntityPlayerMP && (stack.func_77973_b() instanceof TrinketFairyRing || stack.func_77973_b() instanceof TrinketDwarfRing)) {
                NetworkHandler.sendPlayerDataAll(player, playerCap);
            }
            if (playerCap != null && !playerCap.getFood().contains("fairy_dew")) {
                EffectsFairyRing.FairyEquip(stack, player);
            }
        }
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
        super.playerUnequipped(stack, player);
        boolean client = player.field_70170_p.field_72995_K;
        ISizeCap playerCap = (ISizeCap)player.getCapability(SizeCapPro.sizeCapability, null);
        if (playerCap != null && player instanceof EntityPlayerMP && (stack.func_77973_b() instanceof TrinketFairyRing || stack.func_77973_b() instanceof TrinketDwarfRing)) {
            NetworkHandler.sendPlayerDataAll(player, playerCap);
        }
        if (!TrinketHelper.AccessoryCheck(player, stack.func_77973_b()) && playerCap != null && !playerCap.getFood().contains("fairy_dew")) {
            EffectsFairyRing.FairyUnequip(stack, player);
        }
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketsConfig.SERVER.FAIRY_RING.enabled;
    }

    @Override
    public boolean hasDiscription(ItemStack stack) {
        return true;
    }
}

