/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.swim.SwimAttribute;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.betterdiving.BetterDivingCompat;
import xzeroair.trinkets.util.compat.toughasnails.TANCompat;
import xzeroair.trinkets.util.handlers.ClimbHandler;

public class TrinketSea
extends AccessoryBase {
    private final UUID uuid = UUID.fromString("6029aecd-318e-4b45-8c36-2ddd7f481e36");

    public TrinketSea(String name) {
        super(name);
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        SwimAttribute.addModifier((EntityLivingBase)player, TrinketsConfig.SERVER.SEA_STONE.speed, this.uuid, 0);
        if (TrinketsConfig.SERVER.SEA_STONE.underwater_breathing) {
            if (!TrinketsConfig.SERVER.SEA_STONE.always_full) {
                if (player.func_70086_ai() < 20) {
                    player.func_70050_g(20);
                    BetterDivingCompat.setOxygen(player, 100);
                }
            } else {
                player.func_70050_g(300);
                BetterDivingCompat.setOxygen(player, 300);
            }
        }
        if (TrinketsConfig.SERVER.SEA_STONE.prevent_thirst) {
            TANCompat.clearThirst((EntityLivingBase)player);
        }
        if (TrinketsConfig.SERVER.SEA_STONE.C06_Sea_Stone_Swim_Tweaks) {
            BlockPos head = player.func_180425_c();
            IBlockState headBlock = player.field_70170_p.func_180495_p(head);
            Block block = headBlock.func_177230_c();
            if ((player.func_70090_H() || player.func_180799_ab()) && block != Blocks.field_150350_a) {
                double motion = 0.1;
                double bouyance = 0.25;
                if (player.func_180799_ab()) {
                    motion = 0.09;
                }
                if (!player.func_70093_af()) {
                    player.field_70181_x = 0.0;
                    if (ClimbHandler.movingForward((EntityLivingBase)player, player.func_174811_aO()) && (player.field_70159_w > motion || player.field_70159_w < -motion || player.field_70179_y > motion || player.field_70179_y < -motion)) {
                        player.field_70181_x += MathHelper.func_151237_a((double)(player.func_70040_Z().field_72448_b / 1.0), (double)-0.25, (double)0.25);
                    }
                } else if (!ClimbHandler.movingForward((EntityLivingBase)player, player.func_174811_aO()) && !(player.field_70181_x > 0.0)) {
                    player.field_70181_x = player.func_180799_ab() ? (player.field_70181_x *= 1.75) : (player.field_70181_x *= 1.25);
                }
            }
        }
    }

    @Override
    public void eventPlayerLogout(ItemStack stack, EntityLivingBase player) {
        SwimAttribute.removeModifier(player, this.uuid);
    }

    @Override
    public boolean playerCanEquip(ItemStack stack, EntityLivingBase player) {
        if (TrinketHelper.AccessoryCheck(player, stack.func_77973_b())) {
            return false;
        }
        return super.playerCanEquip(stack, player);
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
        super.playerEquipped(stack, player);
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
        SwimAttribute.removeModifier(player, this.uuid);
        super.playerUnequipped(stack, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playerRender(ItemStack stack, EntityLivingBase player, float partialTicks, boolean isBauble) {
        if (!TrinketsConfig.CLIENT.SEA_STONE.doRender) {
            return;
        }
        float scale = 0.2f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.12f, (float)0.14f);
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.24f, (float)-0.07f);
            GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (player.func_190630_a(EntityEquipmentSlot.CHEST)) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.06f);
        }
        GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.func_190903_i(), ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketsConfig.SERVER.SEA_STONE.enabled;
    }

    @Override
    public boolean hasDiscription(ItemStack stack) {
        return true;
    }
}

