/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerProvider;

public class PacketAccessorySync
implements IMessage {
    int playerId;
    byte slot;
    boolean isTrinket;
    boolean equipped;
    ItemStack Accessory;

    public PacketAccessorySync() {
    }

    public PacketAccessorySync(EntityPlayer player, int slot, boolean isTrinket, boolean equipped) {
        if (!isTrinket) {
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            this.Accessory = baubles2.getStackInSlot(slot);
        } else {
            ITrinketContainerHandler Trinket = (ITrinketContainerHandler)player.getCapability(TrinketContainerProvider.containerCap, null);
            this.Accessory = Trinket.getStackInSlot(slot);
        }
        this.slot = (byte)slot;
        this.isTrinket = isTrinket;
        this.equipped = equipped;
        this.playerId = player.func_145782_y();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.playerId);
        buffer.writeByte((int)this.slot);
        buffer.writeBoolean(this.isTrinket);
        buffer.writeBoolean(this.equipped);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.Accessory);
    }

    public void fromBytes(ByteBuf buffer) {
        this.playerId = buffer.readInt();
        this.slot = buffer.readByte();
        this.isTrinket = buffer.readBoolean();
        this.equipped = buffer.readBoolean();
        this.Accessory = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    public static class Handler
    implements IMessageHandler<PacketAccessorySync, IMessage> {
        public IMessage onMessage(PacketAccessorySync message, MessageContext ctx) {
            Trinkets.proxy.getThreadListener(ctx).func_152344_a(() -> {
                if (Trinkets.proxy.getPlayer(ctx) != null) {
                    EntityPlayer player = (EntityPlayer)Trinkets.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.playerId);
                    if (!message.isTrinket) {
                        IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
                        if (message.slot >= 0) {
                            if (message.equipped) {
                                baubles2.setStackInSlot((int)message.slot, message.Accessory);
                            } else {
                                baubles2.setStackInSlot((int)message.slot, ItemStack.field_190927_a);
                            }
                        }
                    } else {
                        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
                        if (message.slot >= 0) {
                            if (message.equipped) {
                                Trinket.setStackInSlot(message.slot, message.Accessory);
                            } else {
                                Trinket.setStackInSlot(message.slot, ItemStack.field_190927_a);
                            }
                        }
                    }
                }
            });
            return null;
        }
    }
}

