/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.sizeCap.ISizeCap;
import xzeroair.trinkets.capabilities.sizeCap.SizeCapPro;

public class SizeDataPacket
implements IMessage {
    public int size = 100;
    public boolean trans = false;
    public int target = 100;
    public String food = "none";
    public float width = 0.6f;
    public float height = 1.8f;
    public float defaultWidth = 0.6f;
    public float defaultHeight = 1.8f;
    public float eyeHeight = 1.62f;
    public int entityID = 0;

    public SizeDataPacket() {
    }

    public SizeDataPacket(EntityLivingBase entity, int size, boolean trans, int target, String food) {
        this.entityID = entity.func_145782_y();
        this.size = size;
        this.trans = trans;
        this.target = target;
        this.food = food;
        this.width = entity.field_70130_N;
        this.height = entity.field_70131_O;
        this.defaultWidth = entity.field_70130_N;
        this.defaultHeight = entity.field_70131_O;
        this.eyeHeight = entity.func_70047_e();
    }

    public SizeDataPacket(EntityLivingBase entity, ISizeCap cap) {
        this.entityID = entity.func_145782_y();
        this.size = cap.getSize();
        this.trans = cap.getTrans();
        this.target = cap.getTarget();
        this.food = cap.getFood();
        this.width = entity.field_70130_N;
        this.height = entity.field_70131_O;
        this.defaultWidth = entity.field_70130_N;
        this.defaultHeight = entity.field_70131_O;
        this.eyeHeight = entity.func_70047_e();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.size);
        buf.writeBoolean(this.trans);
        buf.writeInt(this.target);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.food);
        buf.writeFloat(this.width);
        buf.writeFloat(this.height);
        buf.writeFloat(this.defaultWidth);
        buf.writeFloat(this.defaultHeight);
        buf.writeFloat(this.eyeHeight);
        buf.writeInt(this.entityID);
    }

    public void fromBytes(ByteBuf buf) {
        this.size = buf.readInt();
        this.trans = buf.readBoolean();
        this.target = buf.readInt();
        ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.width = buf.readFloat();
        this.height = buf.readFloat();
        this.defaultWidth = buf.readFloat();
        this.defaultHeight = buf.readFloat();
        this.eyeHeight = buf.readFloat();
        this.entityID = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<SizeDataPacket, IMessage> {
        public IMessage onMessage(SizeDataPacket message, MessageContext ctx) {
            Trinkets.proxy.getThreadListener(ctx).func_152344_a(() -> {
                Entity entity;
                ISizeCap cap;
                if (Trinkets.proxy.getPlayer(ctx) != null && Trinkets.proxy.getPlayer(ctx).func_130014_f_() != null && (cap = (ISizeCap)(entity = Trinkets.proxy.getPlayer(ctx).func_130014_f_().func_73045_a(message.entityID)).getCapability(SizeCapPro.sizeCapability, null)) != null) {
                    cap.setSize(message.size);
                    cap.setTrans(message.trans);
                    cap.setTarget(message.target);
                    cap.setFood(message.food);
                    cap.setWidth(message.width);
                    cap.setHeight(message.height);
                    cap.setDefaultWidth(message.defaultWidth);
                    cap.setDefaultHeight(message.defaultHeight);
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entity;
                        player.eyeHeight = message.eyeHeight;
                    }
                }
            });
            return null;
        }
    }
}

