/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.eventhandlers;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.util.Random;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.entity.ai.EnderAiEdit;
import xzeroair.trinkets.entity.ai.EnderMoveAI;
import xzeroair.trinkets.entity.ai.EnderQueensKnightAI;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.util.TrinketsConfig;

public class EnderQueenHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void soundEvent(PlaySoundEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p != null && TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketEnderTiara) && event.getSound().func_147650_b().toString().contentEquals("minecraft:entity.endermen.stare")) {
            event.setResultSound(null);
        }
    }

    @SubscribeEvent
    public void EndermanJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityEnderman) {
            EntityEnderman ender = (EntityEnderman)event.getEntity();
            for (Object a : ender.field_70715_bh.field_75782_a.toArray()) {
                EntityAIBase ai = ((EntityAITasks.EntityAITaskEntry)a).field_75733_a;
                if (!ai.toString().startsWith("net.minecraft.entity.monster.EntityEnderman$AIFindPlayer")) continue;
                ender.field_70715_bh.func_85156_a(ai);
            }
            ender.field_70715_bh.func_75776_a(1, (EntityAIBase)new EnderAiEdit(ender));
            ender.field_70715_bh.func_75776_a(2, (EntityAIBase)new EnderQueensKnightAI(ender));
            if (TrinketsConfig.SERVER.ENDER_CROWN.Follow) {
                ender.field_70715_bh.func_75776_a(3, (EntityAIBase)new EnderMoveAI(ender));
            }
        }
    }

    @SubscribeEvent
    public void EnderTeleportEvent(EnderTeleportEvent event) {
        if (event.getEntity() instanceof EntityEnderman) {
            AxisAlignedBB bBox = event.getEntity().func_174813_aQ().func_72314_b(16.0, 4.0, 16.0);
            List entLivList = event.getEntity().func_130014_f_().func_72872_a(EntityPlayer.class, bBox);
            if (!entLivList.isEmpty()) {
                for (EntityPlayer stuff : entLivList) {
                    EntityPlayer player = stuff;
                    if (!TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketEnderTiara) || event.getEntity().func_70090_H()) continue;
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void TargetEvent(LivingSetAttackTargetEvent event) {
        EntityPlayer player;
        if (!TrinketsConfig.SERVER.ENDER_CROWN.attackBack && event.getEntity() instanceof EntityEnderman && event.getTarget() instanceof EntityPlayer && TrinketHelper.AccessoryCheck((EntityLivingBase)(player = (EntityPlayer)event.getTarget()), ModItems.trinkets.TrinketEnderTiara)) {
            ((EntityLiving)event.getEntity()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void experienceDropEvent(LivingExperienceDropEvent event) {
        if (!TrinketsConfig.SERVER.ENDER_CROWN.expDrop && event.getAttackingPlayer() != null && event.getEntityLiving() instanceof EntityEnderman && TrinketHelper.AccessoryCheck((EntityLivingBase)event.getAttackingPlayer(), ModItems.trinkets.TrinketEnderTiara)) {
            event.setDroppedExperience(0);
        }
    }

    @SubscribeEvent
    public void ItemDropEvent(LivingDropsEvent event) {
        if (!TrinketsConfig.SERVER.ENDER_CROWN.itemDrop && event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityEnderman && TrinketHelper.AccessoryCheck((EntityLivingBase)((EntityPlayer)event.getSource().func_76346_g()), ModItems.trinkets.TrinketEnderTiara)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void HurtEvent(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            int chanceNum;
            int chance;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getSource().func_76346_g() instanceof EntityLiving && TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketEnderTiara) && (chance = new Random().nextInt(chanceNum = TrinketsConfig.SERVER.ENDER_CROWN.chance)) == 0) {
                if (TrinketsConfig.SERVER.ENDER_CROWN.dmgChance) {
                    event.setAmount(0.0f);
                }
                if (TrinketsConfig.SERVER.ENDER_CROWN.spawnChance) {
                    EntityEnderman knight = new EntityEnderman(player.func_130014_f_());
                    double x = player.func_180425_c().func_177958_n();
                    double y = player.func_180425_c().func_177956_o();
                    double z = player.func_180425_c().func_177952_p();
                    knight.func_70107_b(x, y, z);
                    player.func_130014_f_().func_72838_d((Entity)knight);
                    if (event.getSource().func_76346_g() != null) {
                        knight.func_70624_b((EntityLivingBase)event.getSource().func_76346_g());
                    }
                }
            }
        }
    }
}

