/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xzeroair.trinkets.util.TrinketsConfig;

public class ClimbHandler {
    static EntityPlayer Player;
    static float PlayerHeight;
    static World world;
    static EnumFacing facing;
    static BlockPos playerPos;
    static BlockPos bodyPos;
    static BlockPos headPos;
    static BlockPos headSpacePos;
    static BlockPos frontBodyPos;
    static BlockPos frontHeadPos;
    static IBlockState body;
    static IBlockState head;
    static IBlockState headSpace;
    static IBlockState frontBody;
    static IBlockState frontHead;

    public void setClimbingPlayer(EntityPlayer player) {
        Player = player;
    }

    public static boolean Climb(EntityPlayer player) {
        if (player != null && !player.field_70128_L) {
            world = player.field_70170_p;
            playerPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            facing = player.func_174811_aO();
            bodyPos = playerPos;
            frontBodyPos = playerPos.func_177982_a(0, 0, 0).func_177972_a(facing);
            body = world.func_180495_p(bodyPos);
            frontBody = world.func_180495_p(frontBodyPos);
            for (String blocks : TrinketsConfig.SERVER.FAIRY_RING.allowedBlocks) {
                if (!body.func_177230_c().getRegistryName().toString().contentEquals(blocks) && !frontBody.func_177230_c().getRegistryName().toString().contentEquals(blocks)) continue;
                return true;
            }
        }
        return false;
    }

    public static void validHeadSpace(EntityPlayer player) {
        AxisAlignedBB bb = player.func_174813_aQ();
        AxisAlignedBB headSpaceTest = head.func_185918_c(world, headPos);
        if (!headSpaceTest.func_72326_a(bb) || !(headSpace.func_177230_c() instanceof BlockAir)) {
            // empty if block
        }
    }

    private static boolean Body() {
        IBlockState Body = body;
        if (Body.func_177230_c() instanceof BlockPane || Body.func_177230_c() instanceof BlockFence || Body.func_177230_c() instanceof BlockWall) {
            return true;
        }
        if (Body.func_177230_c() instanceof BlockStairs && Body.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing && Body.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.TOP) {
            return true;
        }
        if (Body.func_177230_c() instanceof BlockSlab && !Body.func_185915_l() && Body.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
            return true;
        }
        return Body.func_177230_c().func_176205_b((IBlockAccess)world, bodyPos);
    }

    private static boolean Head() {
        IBlockState Head = head;
        if (Head.func_177230_c() instanceof BlockPane || Head.func_177230_c() instanceof BlockFence || Head.func_177230_c() instanceof BlockWall) {
            return body.func_177230_c() instanceof BlockStairs && body.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing;
        }
        if (Head.func_177230_c() instanceof BlockStairs && Head.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing.func_176734_d() && Head.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.BOTTOM) {
            return true;
        }
        if (Head.func_177230_c() instanceof BlockSlab && !Head.func_185915_l() && Head.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return true;
        }
        return Head.func_177230_c().func_176205_b((IBlockAccess)world, headPos);
    }

    private static boolean HeadSpace() {
        return false;
    }

    private static boolean FrontBody() {
        IBlockState FrontBody = frontBody;
        if (body.func_177230_c() instanceof BlockStairs && FrontBody.func_177230_c().func_176205_b((IBlockAccess)world, frontBodyPos) && body.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing) {
            return true;
        }
        if ((body.func_177230_c() instanceof BlockPane || body.func_177230_c() instanceof BlockFence || body.func_177230_c() instanceof BlockWall) && ClimbHandler.Head()) {
            return true;
        }
        return !FrontBody.func_177230_c().func_176205_b((IBlockAccess)world, frontBodyPos);
    }

    private static boolean FrontHead() {
        IBlockState FrontHead = frontHead;
        if (FrontHead.func_177230_c() instanceof BlockStairs && (FrontHead.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing.func_176734_d() || FrontHead.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing)) {
            return true;
        }
        if (ClimbHandler.Body() && ClimbHandler.FrontBody() && !FrontHead.func_185915_l()) {
            return true;
        }
        return FrontHead.func_177230_c().func_176205_b((IBlockAccess)world, frontHeadPos);
    }

    public static boolean movingForward(EntityLivingBase player, EnumFacing facing) {
        return (double)facing.func_176730_m().func_177958_n() * player.field_70159_w > 0.0 || (double)facing.func_176730_m().func_177952_p() * player.field_70179_y > 0.0;
    }

    public static boolean isHeadspaceFree(World world, BlockPos pos, int height) {
        for (int y = 0; y < height; ++y) {
            if (ClimbHandler.isOpenBlockSpace(world, pos.func_177982_a(0, y, 0))) continue;
            return false;
        }
        return true;
    }

    private static boolean isOpenBlockSpace(World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        return !iblockstate.func_177230_c().isNormalCube(iblockstate, (IBlockAccess)world, pos);
    }

    public static boolean canClimb(EntityPlayer player, EnumFacing facing) {
        World world = player.func_130014_f_();
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        IBlockState f = world.func_180495_p(pos.func_177982_a(0, 0, 0).func_177972_a(facing));
        IBlockState t = world.func_180495_p(pos.func_177982_a(0, 1, 0).func_177972_a(facing));
        IBlockState h = world.func_180495_p(pos.func_177982_a(0, 1, 0));
        IBlockState b = world.func_180495_p(pos.func_177982_a(0, 0, 0));
        Block fb = f.func_177230_c();
        Block tb = t.func_177230_c();
        Block hb = h.func_177230_c();
        Block bb = b.func_177230_c();
        boolean fbpass = fb.func_176205_b((IBlockAccess)world, pos.func_177972_a(facing));
        boolean tbpass = tb.func_176205_b((IBlockAccess)world, pos.func_177982_a(0, 1, 0).func_177972_a(facing));
        boolean hbpass = hb.func_176205_b((IBlockAccess)world, pos.func_177982_a(0, 1, 0));
        boolean bbpass = bb.func_176205_b((IBlockAccess)world, pos);
        if (bbpass) {
            if (!fbpass) {
                if (!hbpass) {
                    if (tb instanceof BlockPane) {
                        // empty if block
                    }
                    if (hb instanceof BlockStairs && h.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing.func_176734_d()) {
                        return true;
                    }
                    if (hb instanceof BlockSlab && !h.func_185915_l() && h.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                        return true;
                    }
                }
                if (!tbpass && tb instanceof BlockStairs && (t.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing.func_176734_d() || t.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing)) {
                    return true;
                }
                if (tbpass && hbpass) {
                    return true;
                }
            }
            if (fb instanceof BlockSlab && !f.func_185915_l() && f.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM && hbpass && tb instanceof BlockStairs && t.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing.func_176734_d()) {
                return true;
            }
        }
        if (bb instanceof BlockPane && !(hb instanceof BlockPane)) {
            return true;
        }
        if (bb instanceof BlockStairs && b.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing && b.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.TOP) {
            return true;
        }
        return bb instanceof BlockSlab && !h.func_185915_l() && b.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM;
    }
}

