/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.BiomeDetectorEnd;
import hunternif.mc.atlas.core.BiomeDetectorNether;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.core.TileInfo;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MapDataPacket;
import hunternif.mc.atlas.util.IntVec2;
import hunternif.mc.atlas.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldSavedData;

public class AtlasData
extends WorldSavedData {
    public static final int VERSION = 3;
    public static final String TAG_VERSION = "aaVersion";
    public static final String TAG_DIMENSION_MAP_LIST = "qDimensionMap";
    public static final String TAG_DIMENSION_ID = "qDimensionID";
    public static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    public static final String TAG_BROWSING_X = "qBrowseX";
    public static final String TAG_BROWSING_Y = "qBrowseY";
    public static final String TAG_BROWSING_ZOOM = "qBrowseZoom";
    private final Map<Integer, IBiomeDetector> biomeAnalyzers = new HashMap<Integer, IBiomeDetector>();
    private final BiomeDetectorBase biomeDetectorOverworld = new BiomeDetectorBase();
    private final BiomeDetectorNether biomeDetectorNether = new BiomeDetectorNether();
    private final BiomeDetectorEnd biomeDetectorEnd = new BiomeDetectorEnd();
    private final Map<Integer, DimensionData> dimensionMap = new ConcurrentHashMap<Integer, DimensionData>(2, 0.75f, 2);
    private final Set<EntityPlayer> playersSentTo = new HashSet<EntityPlayer>();
    private NBTTagCompound nbt;

    public AtlasData(String key) {
        super(key);
        this.biomeDetectorOverworld.setScanPonds(SettingsConfig.performance.doScanPonds);
        this.biomeDetectorOverworld.setScanRavines(SettingsConfig.performance.doScanRavines);
        this.setBiomeDetectorForDimension(0, this.biomeDetectorOverworld);
        this.setBiomeDetectorForDimension(-1, this.biomeDetectorNether);
        this.setBiomeDetectorForDimension(1, this.biomeDetectorEnd);
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.nbt = compound;
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d. Updating.", version, 3);
            this.readFromNBT2(compound);
            return;
        }
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound dimTag = dimensionMapList.func_150305_b(d);
            int dimensionID = dimTag.func_74762_e(TAG_DIMENSION_ID);
            NBTTagList dimensionTag = (NBTTagList)dimTag.func_74781_a(TAG_VISITED_CHUNKS);
            DimensionData dimData = this.getDimensionData(dimensionID);
            dimData.readFromNBT(dimensionTag);
            double zoom = (double)dimTag.func_74762_e(TAG_BROWSING_ZOOM) / 1024.0;
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(dimTag.func_74762_e(TAG_BROWSING_X), dimTag.func_74762_e(TAG_BROWSING_Y), zoom);
        }
    }

    public void readFromNBT2(NBTTagCompound compound) {
        this.nbt = compound;
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 2) {
            Log.warn("Loading map with version 2 failed", new Object[0]);
            this.func_76185_a();
            return;
        }
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound dimTag = dimensionMapList.func_150305_b(d);
            int dimensionID = dimTag.func_74762_e(TAG_DIMENSION_ID);
            int[] intArray = dimTag.func_74759_k(TAG_VISITED_CHUNKS);
            DimensionData dimData = this.getDimensionData(dimensionID);
            for (int i = 0; i < intArray.length; i += 3) {
                if (dimData.getTile(intArray[i], intArray[i + 1]) != null) {
                    Log.warn("Duplicate tile at " + intArray[i] + ", " + intArray[i], new Object[0]);
                }
                dimData.setTile(intArray[i], intArray[i + 1], new Tile(intArray[i + 2]));
            }
            Log.info("Updated " + intArray.length / 3 + " chunks", new Object[0]);
            double zoom = (double)dimTag.func_74762_e(TAG_BROWSING_ZOOM) / 1024.0;
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(dimTag.func_74762_e(TAG_BROWSING_X), dimTag.func_74762_e(TAG_BROWSING_Y), zoom);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        return this.writeToNBT(compound, true);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound, boolean includeTileData) {
        NBTTagList dimensionMapList = new NBTTagList();
        compound.func_74768_a(TAG_VERSION, 3);
        for (Map.Entry<Integer, DimensionData> dimensionEntry : this.dimensionMap.entrySet()) {
            NBTTagCompound dimTag = new NBTTagCompound();
            dimTag.func_74768_a(TAG_DIMENSION_ID, dimensionEntry.getKey().intValue());
            DimensionData dimData = dimensionEntry.getValue();
            if (includeTileData) {
                dimTag.func_74782_a(TAG_VISITED_CHUNKS, (NBTBase)dimData.writeToNBT());
            }
            dimTag.func_74768_a(TAG_BROWSING_X, dimData.getBrowsingX());
            dimTag.func_74768_a(TAG_BROWSING_Y, dimData.getBrowsingY());
            dimTag.func_74768_a(TAG_BROWSING_ZOOM, (int)Math.round(dimData.getBrowsingZoom() * 1024.0));
            dimensionMapList.func_74742_a((NBTBase)dimTag);
        }
        compound.func_74782_a(TAG_DIMENSION_MAP_LIST, (NBTBase)dimensionMapList);
        return compound;
    }

    private void setBiomeDetectorForDimension(int dimension, IBiomeDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(dimension, biomeAnalyzer);
    }

    private IBiomeDetector getBiomeDetectorForDimension(int dimension) {
        IBiomeDetector biomeAnalyzer = this.biomeAnalyzers.get(dimension);
        return biomeAnalyzer == null ? this.biomeDetectorOverworld : biomeAnalyzer;
    }

    public ArrayList<TileInfo> updateMapAroundPlayer(EntityPlayer player) {
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int newScanInterval = Math.round(SettingsConfig.performance.newScanInterval * 20.0f);
        int rescanInterval = newScanInterval * SettingsConfig.performance.rescanRate;
        if (player.field_70173_aa % newScanInterval != 0) {
            return updatedTiles;
        }
        int playerX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
        int playerZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
        DimensionData seenChunks = this.getDimensionData(player.field_71093_bK);
        IBiomeDetector biomeDetector = this.getBiomeDetectorForDimension(player.field_71093_bK);
        int scanRadius = SettingsConfig.performance.scanRadius;
        boolean rescanRequired = SettingsConfig.performance.doRescan && player.field_70173_aa % rescanInterval == 0;
        for (double dx = (double)(-scanRadius); dx <= (double)scanRadius; dx += 1.0) {
            for (double dz = (double)(-scanRadius); dz <= (double)scanRadius; dz += 1.0) {
                if (dx * dx + dz * dz > (double)(scanRadius * scanRadius)) continue;
                int x = (int)((double)playerX + dx);
                int z = (int)((double)playerZ + dz);
                Tile oldTile = seenChunks.getTile(x, z);
                int biomeId = AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(player.field_71093_bK, x, z);
                if (biomeId == -1) {
                    if (oldTile != null && !rescanRequired) continue;
                    Chunk chunk = player.func_130014_f_().func_72863_F().func_186026_b(x, z);
                    if (SettingsConfig.performance.forceChunkLoading && chunk == null) {
                        chunk = player.func_130014_f_().func_72863_F().func_186025_d(x, z);
                    }
                    if (chunk == null) continue;
                    if (oldTile != null) {
                        biomeId = biomeDetector.getBiomeID(chunk);
                        if (biomeId == -1) {
                            this.removeTile(player.field_71093_bK, x, z);
                            continue;
                        }
                        if (oldTile.biomeID == biomeId) continue;
                        this.setTile(player.field_71093_bK, x, z, new Tile(biomeId));
                        updatedTiles.add(new TileInfo(x, z, biomeId));
                        continue;
                    }
                    biomeId = biomeDetector.getBiomeID(chunk);
                    if (biomeId == -1) continue;
                    this.setTile(player.field_71093_bK, x, z, new Tile(biomeId));
                    updatedTiles.add(new TileInfo(x, z, biomeId));
                    continue;
                }
                if (oldTile != null && oldTile.biomeID == biomeId) continue;
                this.setTile(player.field_71093_bK, x, z, new Tile(biomeId));
                updatedTiles.add(new TileInfo(x, z, biomeId));
                this.func_76185_a();
            }
        }
        return updatedTiles;
    }

    public void setTile(int dimension, int x, int y, Tile tile) {
        DimensionData dimData = this.getDimensionData(dimension);
        dimData.setTile(x, y, tile);
    }

    private Tile removeTile(int dimension, int x, int y) {
        DimensionData dimData = this.getDimensionData(dimension);
        return dimData.removeTile(x, y);
    }

    public Set<Integer> getVisitedDimensions() {
        return this.dimensionMap.keySet();
    }

    public DimensionData getDimensionData(int dimension) {
        return this.dimensionMap.computeIfAbsent(dimension, k -> new DimensionData(this, dimension));
    }

    public Map<IntVec2, Tile> getSeenChunksInDimension(int dimension) {
        return this.getDimensionData(dimension).getSeenChunks();
    }

    public Collection<EntityPlayer> getSyncedPlayers() {
        return Collections.unmodifiableCollection(this.playersSentTo);
    }

    public boolean isSyncedOnPlayer(EntityPlayer player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, EntityPlayer player) {
        if (this.nbt == null) {
            this.nbt = new NBTTagCompound();
        }
        this.writeToNBT(this.nbt, false);
        PacketDispatcher.sendTo(new MapDataPacket(atlasID, this.nbt), (EntityPlayerMP)player);
        for (Integer i : this.dimensionMap.keySet()) {
            this.dimensionMap.get(i).syncOnPlayer(atlasID, player);
        }
        Log.info("Sent Atlas #%d data to player %s", atlasID, player.func_70005_c_());
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.dimensionMap.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AtlasData)) {
            return false;
        }
        AtlasData other = (AtlasData)((Object)obj);
        if (other.dimensionMap.size() != this.dimensionMap.size()) {
            return false;
        }
        for (Integer key : this.dimensionMap.keySet()) {
            if (this.dimensionMap.get(key).equals(other.dimensionMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

