/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker;

import com.charles445.rltweaker.capability.ITweakerCapability;
import com.charles445.rltweaker.capability.TweakerCapability;
import com.charles445.rltweaker.capability.TweakerStorage;
import com.charles445.rltweaker.command.CommandErrorReport;
import com.charles445.rltweaker.config.JsonConfig;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.handler.MinecraftHandler;
import com.charles445.rltweaker.handler.MotionCheckHandler;
import com.charles445.rltweaker.handler.RecurrentHandler;
import com.charles445.rltweaker.handler.ReskillableHandler;
import com.charles445.rltweaker.handler.RoguelikeHandler;
import com.charles445.rltweaker.handler.RuinsHandler;
import com.charles445.rltweaker.handler.SMEHandler;
import com.charles445.rltweaker.handler.TANHandler;
import com.charles445.rltweaker.handler.WaystonesHandler;
import com.charles445.rltweaker.network.PacketHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="rltweaker", name="RLTweaker", version="0.3.0", acceptedMinecraftVersions="[1.12]", acceptableRemoteVersions="[0.3.0,)")
public class RLTweaker {
    public static final String MODID = "rltweaker";
    public static final String NAME = "RLTweaker";
    public static final String VERSION = "0.3.0";
    @Mod.Instance(value="rltweaker")
    public static RLTweaker instance;
    public static Logger logger;
    public static File jsonDirectory;
    public static Map<String, Object> handlers;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        jsonDirectory = new File(event.getModConfigurationDirectory(), MODID);
        PacketHandler.init();
        CapabilityManager.INSTANCE.register(ITweakerCapability.class, (Capability.IStorage)new TweakerStorage(), TweakerCapability::new);
        handlers.put("minecraft", new MinecraftHandler());
        if (Loader.isModLoaded((String)"reskillable") && ModConfig.server.reskillable.enabled) {
            handlers.put("reskillable", new ReskillableHandler());
        }
        if (Loader.isModLoaded((String)"roguelike") && ModConfig.server.roguelike.enabled) {
            handlers.put("roguelike", new RoguelikeHandler());
        }
        if (Loader.isModLoaded((String)"ruins") && ModConfig.server.ruins.enabled) {
            handlers.put("ruins", new RuinsHandler());
        }
        if (Loader.isModLoaded((String)"waystones") && ModConfig.server.waystones.enabled) {
            handlers.put("waystones", new WaystonesHandler());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"reccomplex") && ModConfig.server.recurrentcomplex.enabled) {
            handlers.put("reccomplex", new RecurrentHandler());
        }
        if (Loader.isModLoaded((String)"toughasnails") && ModConfig.server.toughasnails.enabled) {
            handlers.put("toughasnails", new TANHandler());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        JsonConfig.init();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        new MotionCheckHandler();
        if (Loader.isModLoaded((String)"somanyenchantments") && ModConfig.server.somanyenchantments.enabled) {
            handlers.put("somanyenchantments", new SMEHandler());
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandErrorReport());
    }

    static {
        logger = LogManager.getLogger((String)NAME);
        handlers = new HashMap<String, Object>();
    }
}

