/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.util.ErrorUtil;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RoguelikeHandler {
    public RoguelikeHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (ModConfig.server.roguelike.preventFatigueCrash) {
            World world = event.getWorld();
            if (world.field_72995_K) {
                return;
            }
            Entity entity = event.getEntity();
            if (!(entity instanceof EntityMob) || entity instanceof EntitySlime) {
                return;
            }
            EntityLiving living = (EntityLiving)entity;
            Collection effects = living.func_70651_bq();
            boolean doRemove = false;
            int duration = 1;
            for (PotionEffect effect : effects) {
                Potion potion = effect.func_188419_a();
                if (Potion.func_188409_a((Potion)potion) != 4 || effect.func_76458_c() <= 4) continue;
                doRemove = true;
                duration = effect.func_76459_b();
                RLTweaker.logger.error("Roguelike crash avoided, mob had high mining fatigue: " + effect.func_76458_c());
                ErrorUtil.logSilent("Roguelike Fatigue Crash");
                break;
            }
            if (doRemove) {
                Potion potion = Potion.func_188412_a((int)4);
                living.func_184589_d(potion);
                living.func_70690_d(new PotionEffect(potion, duration, 4));
            }
        }
    }
}

