/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.capability.ITweakerCapability;
import com.charles445.rltweaker.capability.RLCapabilities;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.TANReflect;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class TANHandler {
    private TANReflect reflector;

    public TANHandler() {
        block2: {
            try {
                this.reflector = new TANReflect();
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup TANHandler!", (Throwable)e);
                ErrorUtil.logSilent("TAN Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            try {
                Object data = this.reflector.getThirstData(player);
                float currentExhaustion = this.reflector.readExhaustionFromData(data);
                ITweakerCapability tweakData = RLCapabilities.getTweakerData(player);
                if (ModConfig.server.toughasnails.fixTeleportThirst) {
                    float storedExhaustion = tweakData.getTANExhaustion();
                    float exhaustionChange = currentExhaustion - storedExhaustion;
                    if (event.phase == TickEvent.Phase.START) {
                        if (exhaustionChange > (float)ModConfig.server.toughasnails.teleportThirstThreshold) {
                            this.reflector.setExhaustionInData(data, storedExhaustion);
                        }
                    } else {
                        tweakData.setTANExhaustion(currentExhaustion);
                    }
                }
                if (event.phase == TickEvent.Phase.START && ModConfig.server.toughasnails.sendExtraThirstPackets) {
                    int tanPackets = tweakData.getThirstPacketTicks();
                    if (tanPackets >= ModConfig.server.toughasnails.extraThirstPacketFrequency) {
                        tweakData.setThirstPacketTicks(0);
                        SimpleNetworkWrapper packetHandler = this.reflector.getPacketHandlerInstance();
                        if (packetHandler != null && player instanceof EntityPlayerMP) {
                            packetHandler.sendTo(this.reflector.createUpdateMessageWithStat(data), (EntityPlayerMP)player);
                        }
                    } else {
                        tweakData.incrementThirstPacketTicks();
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                RLTweaker.logger.error("Error in onPlayerTick TANHandler Invoke", (Throwable)e);
                ErrorUtil.logSilent("TANHandler onPlayerTick");
                throw new RuntimeException(e);
            }
        }
    }
}

