/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.page;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.guidebook.gui.GuiPage;
import net.silentchaos512.lib.guidebook.misc.GuideBookUtils;
import net.silentchaos512.lib.util.AssetUtil;

public class ItemDisplay {
    public final int x;
    public final int y;
    public final float scale;
    private final GuiPage gui;
    private final IGuidePage page;
    public ItemStack stack;

    public ItemDisplay(GuideBook book, GuiPage gui, int x, int y, float scale, ItemStack stack, boolean shouldTryTransfer) {
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.stack = stack;
        this.page = shouldTryTransfer ? GuideBookUtils.findFirstPageForStack(book, stack) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPre(GuideBook book) {
        AssetUtil.renderStackToGui(this.stack, this.x, this.y, this.scale);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPost(GuideBook book, int mouseX, int mouseY) {
        if (this.isHovered(book, mouseX, mouseY)) {
            ScaledResolution res;
            int posX;
            Minecraft mc = this.gui.field_146297_k;
            boolean flagBefore = mc.field_71466_p.func_82883_a();
            mc.field_71466_p.func_78264_a(false);
            ITooltipFlag.TooltipFlags tooltipFlag = mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List list = this.stack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)tooltipFlag);
            int maxWidth = 0;
            for (int k = 0; k < list.size(); ++k) {
                maxWidth = Math.max(mc.field_71466_p.func_78256_a((String)list.get(k)), maxWidth);
                if (k == 0) {
                    list.set(k, this.stack.func_77953_t().field_77937_e + (String)list.get(k));
                    continue;
                }
                list.set(k, TextFormatting.GRAY + (String)list.get(k));
            }
            if (this.page != null && this.page != this.gui.pages[0] && this.page != this.gui.pages[1]) {
                list.add(TextFormatting.GOLD + book.i18n.translate("guide.silentlib.clickToSeeRecipe", new Object[0]));
            }
            if ((posX = mouseX) + maxWidth > (res = new ScaledResolution(mc)).func_78326_a() - 15) {
                posX -= maxWidth + 20;
            }
            GuiUtils.drawHoveringText((List)list, (int)posX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
            mc.field_71466_p.func_78264_a(flagBefore);
        }
    }

    public void onMousePress(GuideBook book, int button, int mouseX, int mouseY) {
        if (button == 0 && this.isHovered(book, mouseX, mouseY) && this.page != null && this.page != this.gui.pages[0] && this.page != this.gui.pages[1]) {
            this.gui.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            GuiPage gui = GuideBookUtils.createPageGui(book, this.gui.previousScreen, this.gui, this.page);
            this.gui.field_146297_k.func_147108_a((GuiScreen)gui);
        }
    }

    public boolean isHovered(GuideBook book, int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && (float)mouseX < (float)this.x + 16.0f * this.scale && (float)mouseY < (float)this.y + 16.0f * this.scale;
    }
}

