/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.liquid;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;

@ZenClass(value="crafttweaker.item.WeightedLiquidStack")
@ZenRegister
public final class WeightedLiquidStack {
    private final ILiquidStack stack;
    private final float p;

    public WeightedLiquidStack(ILiquidStack stack, float p) {
        this.stack = stack;
        this.p = p;
    }

    public static List<ILiquidStack> pickRandomDrops(Random random, WeightedLiquidStack[] items) {
        ArrayList<ILiquidStack> result = new ArrayList<ILiquidStack>();
        for (WeightedLiquidStack item : items) {
            if (!(random.nextFloat() <= item.getChance())) continue;
            result.add(item.getStack());
        }
        return result;
    }

    @ZenGetter(value="stack")
    public ILiquidStack getStack() {
        return this.stack;
    }

    @ZenGetter(value="chance")
    public float getChance() {
        return this.p;
    }

    @ZenGetter(value="percent")
    public float getPercent() {
        return this.p * 100.0f;
    }

    public int hashCode() {
        int hash = 17;
        hash = 29 * hash + (this.stack != null ? this.stack.hashCode() : 0);
        hash = 29 * hash + Float.floatToIntBits(this.p);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeightedLiquidStack other = (WeightedLiquidStack)obj;
        return (this.stack == other.stack || this.stack != null && this.stack.equals(other.stack)) && Float.floatToIntBits(this.p) == Float.floatToIntBits(other.p);
    }
}

