/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.init.ModSounds;
import net.silentchaos512.scalinghealth.lib.EnumModParticles;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class ItemDifficultyChanger
extends Item
implements ICustomModel {
    public ItemDifficultyChanger() {
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77952_i() > 1) {
            return;
        }
        String amountStr = String.format("%d", stack.func_77952_i() == Type.ENCHANTED.ordinal() ? (int)Config.Items.enchantedHeartChange : (int)Config.Items.cursedHeartChange);
        if (amountStr.matches("^\\d+")) {
            amountStr = "+" + amountStr;
        }
        String line = ScalingHealth.i18n.itemSubText("difficultychanger", "effectDesc", new Object[]{amountStr});
        list.add(TextFormatting.WHITE + line);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Type type : Type.values()) {
            list.add((Object)new ItemStack((Item)this, 1, type.getItemDamage()));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
        if (data == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        double particleX = player.field_70165_t;
        double particleY = player.field_70163_u + (double)(0.65f * player.field_70131_O);
        double particleZ = player.field_70161_v;
        switch (Type.getByMeta(stack.func_77952_i())) {
            case ENCHANTED: {
                if (!world.field_72995_K) {
                    data.incrementDifficulty(Config.Items.enchantedHeartChange);
                    stack.func_190918_g(1);
                }
                for (int i = 0; i < 20 - 5 * ScalingHealth.proxy.getParticleSettings(); ++i) {
                    double xSpeed = 0.08 * ScalingHealth.random.nextGaussian();
                    double ySpeed = 0.05 * ScalingHealth.random.nextGaussian();
                    double zSpeed = 0.08 * ScalingHealth.random.nextGaussian();
                    ScalingHealth.proxy.spawnParticles(EnumModParticles.ENCHANTED_HEART, new Color(1.0f, 1.0f, 0.5f), world, particleX, particleY, particleZ, xSpeed, ySpeed, zSpeed);
                }
                world.func_184133_a(null, player.func_180425_c(), ModSounds.ENCHANTED_HEART_USE, SoundCategory.PLAYERS, 0.4f, 1.7f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            case CURSED: {
                if (!world.field_72995_K) {
                    data.incrementDifficulty(Config.Items.cursedHeartChange);
                    stack.func_190918_g(1);
                }
                for (int i = 0; i < 20 - 5 * ScalingHealth.proxy.getParticleSettings(); ++i) {
                    double xSpeed = 0.08 * ScalingHealth.random.nextGaussian();
                    double ySpeed = 0.05 * ScalingHealth.random.nextGaussian();
                    double zSpeed = 0.08 * ScalingHealth.random.nextGaussian();
                    ScalingHealth.proxy.spawnParticles(EnumModParticles.CURSED_HEART, new Color(0.4f, 0.0f, 0.6f), world, particleX, particleY, particleZ, xSpeed, ySpeed, zSpeed);
                }
                world.func_184133_a(null, player.func_180425_c(), ModSounds.CURSED_HEART_USE, SoundCategory.PLAYERS, 0.3f, (float)((double)0.7f + (double)0.05f * ScalingHealth.random.nextGaussian()));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        ScalingHealth.logHelper.warn("DifficultyChanger invalid meta: {}", new Object[]{stack.func_77952_i()});
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public String func_77667_c(ItemStack stack) {
        return ScalingHealth.i18n.getKey("item", Type.getByMeta(stack.func_77952_i()).getItemName());
    }

    public void registerModels() {
        for (Type type : Type.values()) {
            ScalingHealth.registry.setModel((Item)this, type.getItemDamage(), type.getItemName());
        }
    }

    static enum Type {
        ENCHANTED,
        CURSED;


        static Type getByMeta(int meta) {
            return Type.values()[meta & 1];
        }

        public String getItemName() {
            return this.name().toLowerCase(Locale.ROOT) + "_heart";
        }

        public int getItemDamage() {
            return this.ordinal();
        }
    }
}

