/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.addon.toughasnails;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.addon.toughasnails.ToughAsNailsAddon;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;
import toughasnails.api.TANCapabilities;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureScale;

public class TemperatureHandler
extends VisualHandler {
    public float defaultIntensity = 0.0f;
    public float mediumIntensity = 0.2f;
    public float maxIntensity = 0.4f;
    public float fadeFactor = 0.005f;
    private static Temperature defaultTemperature = new Temperature(12);

    public TemperatureHandler() {
        super("freeze", "addon for ToughAsNailsAddon");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.defaultIntensity = config.getFloat("defaultIntensity", this.name, this.defaultIntensity, 0.0f, 10000.0f, "");
        this.maxIntensity = config.getFloat("maxIntensity", this.name, this.maxIntensity, 0.0f, 10000.0f, "if it's hot or icy");
        this.mediumIntensity = config.getFloat("mediumIntensity", this.name, this.mediumIntensity, 0.0f, 10000.0f, "if it's warm or cool");
        this.fadeFactor = config.getFloat("fadeFactor", this.name, this.fadeFactor, 0.0f, 10000.0f, "alpha += fadeFactor per Tick");
    }

    @Override
    @Optional.Method(modid="igcm")
    public void registerConfigElements(ConfigBranch branch) {
        branch.registerElement("defaultIntensity", (ConfigElement)new FloatSegment("defaultIntensity", Float.valueOf(0.0f), 0.0f, 10000.0f).setToolTip(new String[]{"the default idensity if everything is fine"}));
        branch.registerElement("maxIntensity", (ConfigElement)new FloatSegment("maxIntensity", Float.valueOf(0.4f), 0.0f, 10000.0f).setToolTip(new String[]{"if it's hot or icy"}));
        branch.registerElement("mediumIntensity", (ConfigElement)new FloatSegment("mediumIntensity", Float.valueOf(0.2f), 0.0f, 10000.0f).setToolTip(new String[]{"if it's warm or cool"}));
        branch.registerElement("fadeFactor", (ConfigElement)new FloatSegment("fadeFactor", Float.valueOf(0.005f), 0.0f, 10000.0f).setToolTip(new String[]{"alpha += fadeFactor per Tick"}));
    }

    @Override
    @Optional.Method(modid="igcm")
    public void receiveConfigElements(ConfigBranch branch) {
        this.defaultIntensity = ((Float)branch.getValue("defaultIntensity")).floatValue();
        this.maxIntensity = ((Float)branch.getValue("maxIntensity")).floatValue();
        this.mediumIntensity = ((Float)branch.getValue("mediumIntensity")).floatValue();
        this.fadeFactor = ((Float)branch.getValue("fadeFactor")).floatValue();
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        VisualPersistent freeze = VisualManager.getPersitentVisual(ToughAsNailsAddon.freeze);
        VisualPersistent heat = VisualManager.getPersitentVisual(ToughAsNailsAddon.heat);
        if (freeze != null && heat != null) {
            float aimedHeat = this.defaultIntensity;
            float aimedFreeze = this.defaultIntensity;
            Temperature temp = defaultTemperature;
            if (player != null) {
                temp = ((ITemperature)player.getCapability(TANCapabilities.TEMPERATURE, null)).getTemperature();
            }
            if (temp == null) {
                temp = defaultTemperature;
            }
            TemperatureScale.TemperatureRange range = temp.getRange();
            switch (range) {
                case ICY: {
                    aimedHeat = 0.0f;
                    aimedFreeze = this.maxIntensity;
                    break;
                }
                case COOL: {
                    aimedHeat = 0.0f;
                    aimedFreeze = this.mediumIntensity * temp.getRangeDelta(true);
                    break;
                }
                case MILD: {
                    aimedHeat = this.defaultIntensity;
                    aimedFreeze = this.defaultIntensity;
                    break;
                }
                case WARM: {
                    aimedHeat = this.mediumIntensity * temp.getRangeDelta(false);
                    aimedFreeze = 0.0f;
                    break;
                }
                case HOT: {
                    aimedHeat = this.maxIntensity;
                    aimedFreeze = 0.0f;
                }
            }
            if (freeze.getIntensity(1.0f) < aimedFreeze) {
                freeze.setIntensity(Math.min(freeze.getIntensity(1.0f) + this.fadeFactor, aimedFreeze));
            } else if (freeze.getIntensity(1.0f) > aimedFreeze) {
                freeze.setIntensity(Math.max(freeze.getIntensity(1.0f) - this.fadeFactor, aimedFreeze));
            }
            if (heat.getIntensity(1.0f) < aimedHeat) {
                heat.setIntensity(Math.min(heat.getIntensity(1.0f) + this.fadeFactor, aimedHeat));
            } else if (heat.getIntensity(1.0f) > aimedHeat) {
                heat.setIntensity(Math.max(heat.getIntensity(1.0f) - this.fadeFactor, aimedHeat));
            }
        }
    }
}

