/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public class SandSplatHandler
extends VisualHandler {
    public float defaultmodifier = 0.5f;
    public float sprintingmodifier = 1.5f;
    public int minDuration = 100;
    public int maxDuration = 100;

    public SandSplatHandler() {
        super("sand", "walking on sand");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.defaultmodifier = config.getFloat("defaultmodifier", this.name, 0.5f, 0.0f, 10000.0f, "modifier: splashes per tick = (int) modifier * Math.random()");
        this.sprintingmodifier = config.getFloat("sprintingmodifier", this.name, 1.5f, 0.0f, 10000.0f, "sprinting -> increased modifier");
        this.minDuration = config.getInt("minDuration", this.name, 100, 1, 10000, "min duration of one splash");
        this.maxDuration = config.getInt("maxDuration", this.name, 100, 1, 10000, "max duration of one splash");
    }

    @Override
    @Optional.Method(modid="igcm")
    public void registerConfigElements(ConfigBranch branch) {
        branch.registerElement("defaultmodifier", (ConfigElement)new FloatSegment("defaultmodifier", Float.valueOf(0.5f), 0.0f, 10000.0f).setToolTip(new String[]{"modifier: splashes per tick = (int) modifier * Math.random()"}));
        branch.registerElement("sprintingmodifier", (ConfigElement)new FloatSegment("sprintingmodifier", Float.valueOf(1.5f), 0.0f, 10000.0f).setToolTip(new String[]{"sprinting -> increased modifier"}));
        branch.registerElement("minDuration", (ConfigElement)new IntegerSegment("minDuration", Integer.valueOf(100), 1, 10000).setToolTip(new String[]{"min duration of one splash"}));
        branch.registerElement("maxDuration", (ConfigElement)new IntegerSegment("maxDuration", Integer.valueOf(100), 1, 10000).setToolTip(new String[]{"max duration of one splash"}));
    }

    @Override
    @Optional.Method(modid="igcm")
    public void receiveConfigElements(ConfigBranch branch) {
        this.defaultmodifier = ((Float)branch.getValue("defaultmodifier")).floatValue();
        this.sprintingmodifier = ((Float)branch.getValue("sprintingmodifier")).floatValue();
        this.minDuration = (Integer)branch.getValue("minDuration");
        this.maxDuration = (Integer)branch.getValue("maxDuration");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        if (player != null && player.field_70122_E && this.isOnSand(player)) {
            float modifier = this.defaultmodifier;
            if (player.func_70051_ag()) {
                modifier = this.sprintingmodifier;
            }
            VisualManager.addVisualsWithShading(VisualType.sand, (int)(Math.random() * (double)modifier), this.minDuration, this.maxDuration);
        }
    }

    private boolean isOnSand(EntityPlayer player) {
        BlockPos pos = player.func_180425_c().func_177977_b();
        int posX = (int)player.field_70165_t;
        int posY = (int)(player.field_70163_u - 1.0);
        int posZ = (int)player.field_70161_v;
        return player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150354_m;
    }
}

