/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class VisualFadeOut
extends Visual {
    public int duration;
    public int lifeTime = 0;

    public VisualFadeOut(VisualType type, float intensity, int minDuration, int maxDuration, Color color) {
        super(type, intensity, color);
        this.duration = minDuration + (maxDuration - minDuration > 0 ? rand.nextInt(maxDuration - minDuration) : minDuration);
    }

    public VisualFadeOut(VisualType type, float intensity, int minDuration, int maxDuration) {
        this(type, intensity, minDuration, maxDuration, Color.WHITE);
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        ++this.lifeTime;
    }

    @Override
    public float getIntensity(float partialTicks) {
        float lifeTime = (float)this.lifeTime + partialTicks;
        if (this.type.supportsColor()) {
            return (float)this.color.getAlpha() / 255.0f * this.intensity * (1.0f - lifeTime / (float)this.duration);
        }
        return this.intensity * (1.0f - lifeTime / (float)this.duration);
    }

    @Override
    public boolean hasFinished() {
        return this.lifeTime >= this.duration;
    }

    @Override
    public boolean isRandomized() {
        return this.type.isRandomized();
    }
}

