/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerLiteralTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AnnotatedSimpleType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import org.jetbrains.annotations.NotNull;

public final class KotlinTypeFactory {
    public static final KotlinTypeFactory INSTANCE;

    private final MemberScope computeMemberScope(TypeConstructor constructor, List<? extends TypeProjection> arguments2) {
        MemberScope memberScope2;
        ClassifierDescriptor descriptor2 = constructor.getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = descriptor2;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            memberScope2 = descriptor2.getDefaultType().getMemberScope();
        } else if (classifierDescriptor instanceof ClassDescriptor) {
            if (arguments2.isEmpty()) {
                memberScope2 = ((ClassDescriptor)descriptor2).getDefaultType().getMemberScope();
            } else {
                MemberScope memberScope3 = ((ClassDescriptor)descriptor2).getMemberScope(TypeConstructorSubstitution.Companion.create(constructor, arguments2));
                memberScope2 = memberScope3;
                Intrinsics.checkExpressionValueIsNotNull(memberScope3, "descriptor.getMemberScop\u2026(constructor, arguments))");
            }
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            MemberScope memberScope4 = ErrorUtils.createErrorScope("Scope for abbreviation: " + ((TypeAliasDescriptor)descriptor2).getName(), true);
            memberScope2 = memberScope4;
            Intrinsics.checkExpressionValueIsNotNull(memberScope4, "ErrorUtils.createErrorSc\u2026{descriptor.name}\", true)");
        } else {
            throw (Throwable)new IllegalStateException("Unsupported classifier: " + descriptor2 + " for constructor: " + constructor);
        }
        return memberScope2;
    }

    @JvmStatic
    @NotNull
    public static final SimpleType simpleType(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, @NotNull List<? extends TypeProjection> arguments2, boolean nullable) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        if (annotations2.isEmpty() && arguments2.isEmpty() && !nullable && constructor.getDeclarationDescriptor() != null) {
            ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor, "constructor.declarationDescriptor!!");
            SimpleType simpleType2 = classifierDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "constructor.declarationDescriptor!!.defaultType");
            return simpleType2;
        }
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, constructor, arguments2, nullable, INSTANCE.computeMemberScope(constructor, arguments2));
    }

    @JvmStatic
    @NotNull
    public static final SimpleType simpleTypeWithNonTrivialMemberScope(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor, @NotNull List<? extends TypeProjection> arguments2, boolean nullable, @NotNull MemberScope memberScope2) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
        SimpleTypeImpl simpleTypeImpl = new SimpleTypeImpl(constructor, arguments2, nullable, memberScope2);
        boolean bl = false;
        boolean bl2 = false;
        SimpleTypeImpl it = simpleTypeImpl;
        boolean bl3 = false;
        return annotations2.isEmpty() ? (SimpleType)it : (SimpleType)new AnnotatedSimpleType(it, annotations2);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType simpleNotNullType(@NotNull Annotations annotations2, @NotNull ClassDescriptor descriptor2, @NotNull List<? extends TypeProjection> arguments2) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        TypeConstructor typeConstructor2 = descriptor2.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "descriptor.typeConstructor");
        return KotlinTypeFactory.simpleType(annotations2, typeConstructor2, arguments2, false);
    }

    @JvmStatic
    @NotNull
    public static final UnwrappedType flexibleType(@NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        if (Intrinsics.areEqual(lowerBound, upperBound)) {
            return lowerBound;
        }
        return new FlexibleTypeImpl(lowerBound, upperBound);
    }

    @JvmStatic
    @NotNull
    public static final SimpleType integerLiteralType(@NotNull Annotations annotations2, @NotNull IntegerLiteralTypeConstructor constructor, boolean nullable) {
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        TypeConstructor typeConstructor2 = constructor;
        List list = CollectionsKt.emptyList();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Scope for integer literal type", true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026eger literal type\", true)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor2, list, nullable, memberScope2);
    }

    private KotlinTypeFactory() {
    }

    static {
        KotlinTypeFactory kotlinTypeFactory;
        INSTANCE = kotlinTypeFactory = new KotlinTypeFactory();
    }
}

