/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor;

import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.config.IConfiguration;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class WolfArmorConfiguration
implements IConfiguration {
    private Configuration config;
    private boolean isWolfChestEnabled = DEFAULT_WOLF_CHEST_ENABLED;
    private boolean isWolfArmorRenderEnabled = true;
    private boolean isWolfChestRenderEnabled = true;
    private boolean isWolfHealthDisplayEnabled = true;
    private boolean isWolfArmorDisplayEnabled = true;
    private boolean areHowlingUntamedWolvesEnabled = false;
    private boolean shouldWolvesEatWhenDamaged = true;
    private int wolfChestSizeHorizontal = 3;
    private int wolfChestSizeVertical = 2;
    private static final String SETTING_WOLF_CHEST_ENABLED = "config.wolfarmor.general.enableChests";
    private static final String SETTING_WOLF_CHEST_HORIZONTAL = "config.wolfarmor.general.chestSize.horizontal";
    private static final String SETTING_WOLF_CHEST_VERTICAL = "config.wolfarmor.general.chestSize.vertical";
    private static final Boolean DEFAULT_WOLF_CHEST_ENABLED = true;
    private static final int DEFAULT_WOLF_CHEST_HORIZONTAL = 3;
    private static final int DEFAULT_WOLF_CHEST_VERTICAL = 2;
    private static final String SETTING_WOLF_ARMOR_RENDER_ENABLED = "config.wolfarmor.client.enableWolfArmorRender";
    private static final String SETTING_WOLF_CHEST_RENDER_ENABLED = "config.wolfarmor.client.enableWolfChestRender";
    private static final String SETTING_WOLF_ARMOR_DISPLAY_ENABLED = "config.wolfarmor.client.enableWolfArmorDisplay";
    private static final String SETTING_WOLF_HEALTH_DISPLAY_ENABLED = "config.wolfarmor.client.enableWolfHealthDisplay";
    private static final boolean DEFAULT_WOLF_ARMOR_RENDER_ENABLED = true;
    private static final boolean DEFAULT_WOLF_CHEST_RENDER_ENABLED = true;
    private static final boolean DEFAULT_WOLF_ARMOR_DISPLAY_ENABLED = true;
    private static final boolean DEFAULT_WOLF_HEALTH_DISPLAY_ENABLED = true;
    private static final String CATEGORY_BEHAVIOR = "behavior";
    private static final String SETTING_HOWLING_UNTAMED_WOLVES_ENABLED = "config.wolfarmor.behavior.enableHowlingUntamedWolves";
    private static final String SETTING_WOLVES_EAT_FOOD_IN_INVENTORY = "config.wolfarmor.behavior.shouldWolvesEatWhenDamaged";
    private static final boolean DEFAULT_HOWLING_UNTAMED_WOLVES_ENABLED = false;
    private static final boolean DEFAULT_WOLVES_EAT_FOOD_IN_INVENTORY = true;

    @Override
    public void initializeConfig(@Nonnull FMLPreInitializationEvent preInitializationEvent) {
        this.config = new Configuration(WolfArmorConfiguration.getConfigurationFile(preInitializationEvent));
        WolfArmorMod.getLogger().debug("Loading mod configuration...");
        this.config.load();
        WolfArmorMod.getLogger().debug("Mod configuration loaded.");
        this.syncConfig(preInitializationEvent.getSide() == Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("wolfarmor")) {
            this.syncConfig(FMLCommonHandler.instance().getSide() == Side.CLIENT);
        }
    }

    private void syncIsWolfChestEnabled() {
        this.isWolfChestEnabled = this.getSettingWolfChestsEnabled().getBoolean();
    }

    private void syncIsWolfArmorRenderEnabled() {
        this.isWolfArmorRenderEnabled = this.getSettingWolfArmorRenderEnabled().getBoolean();
    }

    private void syncIsWolfChestRenderEnabled() {
        this.isWolfChestRenderEnabled = this.getSettingWolfChestRenderEnabled().getBoolean();
    }

    private void syncIsWolfArmorDisplayEnabled() {
        this.isWolfArmorDisplayEnabled = this.getSettingWolfArmorDisplayEnabled().getBoolean();
    }

    private void syncIsWolfHealthDisplayEnabled() {
        this.isWolfHealthDisplayEnabled = this.getSettingWolfHealthDisplayEnabled().getBoolean();
    }

    private void syncAreHowlingUntamedWolvesEnabled() {
        this.areHowlingUntamedWolvesEnabled = this.getSettingHowlingUntamedWolvesEnabled().getBoolean();
    }

    private void syncShouldWolvesEatWhenDamaged() {
        this.shouldWolvesEatWhenDamaged = this.getSettingWolvesEatWhenDamaged().getBoolean();
    }

    private void syncWolfChestSize() {
        this.wolfChestSizeHorizontal = this.getSettingWolfChestSizeHorizontal().getInt();
        this.wolfChestSizeVertical = this.getSettingWolfChestSizeVertical().getInt();
    }

    private void syncConfig(boolean isClientSide) {
        this.syncIsWolfChestEnabled();
        this.syncWolfChestSize();
        if (isClientSide) {
            this.syncIsWolfArmorRenderEnabled();
            this.syncIsWolfChestRenderEnabled();
            this.syncIsWolfArmorDisplayEnabled();
            this.syncIsWolfHealthDisplayEnabled();
        }
        this.syncAreHowlingUntamedWolvesEnabled();
        this.syncShouldWolvesEatWhenDamaged();
        if (this.config.hasChanged()) {
            WolfArmorMod.getLogger().debug("Saving configuration...");
            this.config.save();
            WolfArmorMod.getLogger().debug("Mod configuration saved.");
        }
    }

    @Nonnull
    private static File getConfigurationFile(@Nonnull FMLPreInitializationEvent preInitializationEvent) {
        File mainConfig;
        WolfArmorMod.getLogger().debug("Retrieving config file...");
        File configDir = new File(preInitializationEvent.getModConfigurationDirectory() + "/attributestudios");
        if (!configDir.exists()) {
            WolfArmorMod.getLogger().debug("Creating new top-level mod config directory...");
            configDir.mkdirs();
        }
        if (!(mainConfig = new File(configDir.getPath() + "/" + "wolfarmor" + ".cfg")).exists()) {
            WolfArmorMod.getLogger().debug("Configuration file not found. A new configuration file will be created.");
        }
        return mainConfig;
    }

    @Override
    public boolean getIsWolfChestEnabled() {
        return this.isWolfChestEnabled;
    }

    @Override
    public boolean getIsWolfArmorRenderEnabled() {
        return this.isWolfArmorRenderEnabled;
    }

    @Override
    public boolean getIsWolfChestRenderEnabled() {
        return this.isWolfChestRenderEnabled;
    }

    @Override
    public boolean getIsWolfArmorDisplayEnabled() {
        return this.isWolfArmorDisplayEnabled;
    }

    @Override
    public boolean getIsWolfHealthDisplayEnabled() {
        return this.isWolfHealthDisplayEnabled;
    }

    @Override
    public boolean getAreHowlingUntamedWolvesEnabled() {
        return this.areHowlingUntamedWolvesEnabled;
    }

    @Override
    public boolean getShouldWolvesEatWhenDamaged() {
        return this.shouldWolvesEatWhenDamaged;
    }

    @Override
    public int getWolfChestSizeHorizontal() {
        return this.wolfChestSizeHorizontal;
    }

    @Override
    public int getWolfChestSizeVertical() {
        return this.wolfChestSizeVertical;
    }

    @Override
    public void syncSettings(NBTTagCompound settingsData) {
    }

    @Override
    @Nonnull
    public Property getSettingWolfChestsEnabled() {
        return this.config.get("general", SETTING_WOLF_CHEST_ENABLED, DEFAULT_WOLF_CHEST_ENABLED.booleanValue(), "Enables or disables wolf backpacks.");
    }

    @Override
    @Nonnull
    public Property getSettingWolfArmorRenderEnabled() {
        return this.config.get("client", SETTING_WOLF_ARMOR_RENDER_ENABLED, true, "Enables or disables rendering of wolf armor.");
    }

    @Override
    @Nonnull
    public Property getSettingWolfChestRenderEnabled() {
        return this.config.get("client", SETTING_WOLF_CHEST_RENDER_ENABLED, true, "Enables or disables rendering of wolf backpacks.");
    }

    @Override
    @Nonnull
    public Property getSettingWolfArmorDisplayEnabled() {
        return this.config.get("client", SETTING_WOLF_ARMOR_DISPLAY_ENABLED, true, "Enables or disables displaying a wolf's armor value in the wolf inventory screen.");
    }

    @Override
    @Nonnull
    public Property getSettingWolfHealthDisplayEnabled() {
        return this.config.get("client", SETTING_WOLF_HEALTH_DISPLAY_ENABLED, true, "Enables or disables displaying a wolf's health value in the wolf inventory screen.");
    }

    @Override
    @Nonnull
    public Property getSettingHowlingUntamedWolvesEnabled() {
        return this.config.get(CATEGORY_BEHAVIOR, SETTING_HOWLING_UNTAMED_WOLVES_ENABLED, false, "Enables or disables untamed wolves howling at the full moon.");
    }

    @Override
    @Nonnull
    public Property getSettingWolvesEatWhenDamaged() {
        return this.config.get(CATEGORY_BEHAVIOR, SETTING_WOLVES_EAT_FOOD_IN_INVENTORY, true, "Enables or disables wolves eating food in their inventories when their health is low.");
    }

    @Override
    @Nonnull
    public Property getSettingWolfChestSizeHorizontal() {
        return this.config.get("general", SETTING_WOLF_CHEST_HORIZONTAL, 3, "Sets the horizontal size of the wolf chest", 1, 5);
    }

    @Override
    @Nonnull
    public Property getSettingWolfChestSizeVertical() {
        return this.config.get("general", SETTING_WOLF_CHEST_VERTICAL, 2, "Sets the vertical size of the wolf chest", 1, 3);
    }
}

