/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.client.gui;

import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.api.util.Resources;
import dev.satyrn.wolfarmor.common.inventory.ContainerWolfInventory;
import dev.satyrn.wolfarmor.common.network.PacketHandler;
import dev.satyrn.wolfarmor.common.network.packets.WolfDropChestMessage;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;

@SideOnly(value=Side.CLIENT)
public class GuiWolfInventory
extends GuiContainer {
    private IInventory wolfInventory;
    private IInventory playerInventory;
    private EntityWolf theWolf;
    private float screenPositionX;
    private float screenPositionY;
    private final IArmoredWolf wolfArmor;
    private final Rectangle EMPTY_SLOT = new Rectangle(7, 83, 18, 18);
    private final Rectangle BUTTON_AREA = new Rectangle(7, 35, 18, 18);
    private final Rectangle BUTTON_TEXTURE = new Rectangle(0, 173, 18, 18);
    private final Rectangle EMPTY_CHEST_BG = new Rectangle(176, 0, 18, 18);

    public GuiWolfInventory(@Nonnull IInventory playerInventory, @Nonnull IInventory wolfInventory, @Nonnull EntityWolf theWolf, @Nonnull EntityPlayer player) {
        super((Container)new ContainerWolfInventory(playerInventory, wolfInventory, theWolf, player));
        this.wolfArmor = (IArmoredWolf)theWolf;
        this.wolfInventory = wolfInventory;
        this.playerInventory = playerInventory;
        this.theWolf = theWolf;
        this.field_146291_p = false;
        this.field_147000_g = 172;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isChestButtonHovered(mouseX, mouseY)) {
            PacketHandler.getChannel().sendToServer((IMessage)new WolfDropChestMessage(this.theWolf.func_145782_y()));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String wolfName = this.theWolf.func_70005_c_();
        this.field_146289_q.func_78276_b(this.wolfInventory.func_145818_k_() ? this.wolfInventory.func_70005_c_() : I18n.func_135052_a((String)this.wolfInventory.func_70005_c_(), (Object[])new Object[]{wolfName}), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145818_k_() ? this.playerInventory.func_70005_c_() : I18n.func_135052_a((String)this.playerInventory.func_70005_c_(), (Object[])new Object[0]), 8, this.field_147000_g - 98, 0x404040);
        this.drawWolfHealthAndArmor();
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.screenPositionX = mouseX;
        this.screenPositionY = mouseY;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        if (this.wolfArmor.getHasChest() && this.isChestButtonHovered(mouseX, mouseY)) {
            ArrayList<String> displayText = new ArrayList<String>();
            displayText.add(I18n.func_135052_a((String)"gui.wolfarmor.inventory.remove_chest", (Object[])new Object[0]));
            this.drawHoveringText(displayText, mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Point origin = this.getOrigin();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Resources.TEXTURE_GUI_WOLF_INVENTORY);
        this.func_73729_b(origin.getX(), origin.getY(), 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.wolfArmor.getHasArmor()) {
            this.func_73729_b(origin.getX() + 7, origin.getY() + 17, this.EMPTY_SLOT.getX(), this.EMPTY_SLOT.getY(), this.EMPTY_SLOT.getWidth(), this.EMPTY_SLOT.getHeight());
        }
        int wolfInventorySizeX = WolfArmorMod.getConfiguration().getWolfChestSizeHorizontal();
        int wolfInventorySizeY = WolfArmorMod.getConfiguration().getWolfChestSizeVertical();
        Point chestOrigin = new Point((5 - wolfInventorySizeX) * 9 + 79, (3 - wolfInventorySizeY) * 9 + 17);
        if (this.wolfArmor.getHasChest()) {
            for (int xOffset = 0; xOffset < wolfInventorySizeX; ++xOffset) {
                for (int yOffset = 0; yOffset < wolfInventorySizeY; ++yOffset) {
                    this.func_73729_b(origin.getX() + chestOrigin.getX() + this.EMPTY_SLOT.getWidth() * xOffset, origin.getY() + chestOrigin.getY() + this.EMPTY_SLOT.getHeight() * yOffset, this.EMPTY_SLOT.getX(), this.EMPTY_SLOT.getY(), this.EMPTY_SLOT.getWidth(), this.EMPTY_SLOT.getHeight());
                }
            }
        } else {
            for (int xSlot = 0; xSlot < wolfInventorySizeX; ++xSlot) {
                for (int ySlot = 0; ySlot < wolfInventorySizeY; ++ySlot) {
                    int textureXOffset = (wolfInventorySizeX > 1 ? 1 : 0) + (xSlot > 0 ? (xSlot == wolfInventorySizeX - 1 ? 2 : 1) : 0);
                    int textureYOffset = (wolfInventorySizeY > 1 ? 1 : 0) + (ySlot > 0 ? (ySlot == wolfInventorySizeY - 1 ? 2 : 1) : 0);
                    this.func_73729_b(origin.getX() + chestOrigin.getX() + this.EMPTY_CHEST_BG.getWidth() * xSlot, origin.getY() + chestOrigin.getY() + this.EMPTY_CHEST_BG.getHeight() * ySlot, textureXOffset * this.EMPTY_CHEST_BG.getWidth() + this.EMPTY_CHEST_BG.getX(), textureYOffset * this.EMPTY_CHEST_BG.getHeight() + this.EMPTY_CHEST_BG.getY(), this.EMPTY_CHEST_BG.getWidth(), this.EMPTY_CHEST_BG.getHeight());
                }
            }
        }
        GuiInventory.func_147046_a((int)(origin.getX() + 51), (int)(origin.getY() + 60), (int)30, (float)((float)(origin.getX() + 51) - this.screenPositionX), (float)((float)(origin.getY() - 50) - this.screenPositionY), (EntityLivingBase)this.theWolf);
        GlStateManager.func_179121_F();
        if (this.wolfArmor.getHasChest()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(Resources.TEXTURE_GUI_WOLF_INVENTORY);
            this.func_73729_b(origin.getX() + this.BUTTON_AREA.getX(), origin.getY() + this.BUTTON_AREA.getY(), this.BUTTON_TEXTURE.getX() + (this.isChestButtonHovered(mouseX, mouseY) ? this.BUTTON_TEXTURE.getWidth() : 0), this.BUTTON_TEXTURE.getY(), this.BUTTON_TEXTURE.getWidth(), this.BUTTON_TEXTURE.getHeight());
            GlStateManager.func_179121_F();
        }
    }

    private void drawWolfHealthAndArmor() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
        if (WolfArmorMod.getConfiguration().getIsWolfHealthDisplayEnabled()) {
            int health = (int)Math.ceil(this.theWolf.func_110143_aJ());
            float maxHealth = this.theWolf.func_110138_aP();
            int rowOffset = (int)Math.min((maxHealth + 0.5f) / 2.0f, 30.0f);
            int yPosition = 160;
            int columnOffset = 0;
            while (rowOffset > 0) {
                int rowIterate = Math.min(rowOffset, 10);
                rowOffset -= rowIterate;
                for (int row = rowIterate - 1; row >= 0; --row) {
                    int xPosition = row * 8 + 5;
                    this.func_73729_b(xPosition, yPosition, 16, 0, 9, 9);
                    if (row * 2 + 1 + columnOffset < health) {
                        this.func_73729_b(xPosition, yPosition, 52, 0, 9, 9);
                    }
                    if (row * 2 + 1 + columnOffset != health) continue;
                    this.func_73729_b(xPosition, yPosition, 61, 0, 9, 9);
                }
                columnOffset += 20;
            }
        }
        if (WolfArmorMod.getConfiguration().getIsWolfArmorDisplayEnabled() && this.wolfArmor.getHasArmor()) {
            int yPosition = 160;
            int armor = this.theWolf.func_70658_aO();
            double maxArmor = 20.0;
            int rowOffset = (int)Math.min((maxArmor + 0.5) / 2.0, 30.0);
            int columnOffset = 0;
            while (rowOffset > 0) {
                int rowIterate = Math.min(rowOffset, 10);
                rowOffset -= rowIterate;
                for (int row = rowIterate - 1; row >= 0; --row) {
                    int xPosition = this.field_146999_f - row * 8 - 14;
                    this.func_73729_b(xPosition, yPosition, 16, 9, 9, 9);
                    if (row * 2 + 1 + columnOffset < armor) {
                        this.func_73729_b(xPosition, yPosition, 34, 9, 9, 9);
                    }
                    if (row * 2 + 1 + columnOffset != armor) continue;
                    this.func_73729_b(xPosition, yPosition, 25, 9, 9, 9);
                }
                columnOffset += 20;
            }
        }
        GlStateManager.func_179121_F();
    }

    private Point getOrigin() {
        return new Point((this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2);
    }

    private Point getLocalFromScreen(int x, int y) {
        Point origin = this.getOrigin();
        int mouseLocX = x - origin.getX();
        int mouseLocY = y - origin.getY();
        return new Point(mouseLocX, mouseLocY);
    }

    private boolean isChestButtonHovered(int mouseX, int mouseY) {
        Point mouseLoc = this.getLocalFromScreen(mouseX, mouseY);
        return mouseLoc.getX() >= this.BUTTON_AREA.getX() && mouseLoc.getY() >= this.BUTTON_AREA.getY() && mouseLoc.getX() < this.BUTTON_AREA.getX() + this.BUTTON_AREA.getWidth() && mouseLoc.getY() < this.BUTTON_AREA.getY() + this.BUTTON_AREA.getHeight();
    }
}

