/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;

@Config(modid="iseedragons")
public class StaticConfig {
    @Config.Comment(value={"A list of entities and view distences "})
    @Config.Name(value="EntityDistanceOverrides")
    public static Map<String, Integer> distanceOverrides;
    @Config.Comment(value={"The default % chance for a block to drop items when smashed by a dragon"})
    public static Integer defaultDropChance;
    @Config.Comment(value={"The default % chance for a block to play sound and particle effects when smashed by a dragon"})
    public static Integer defaultEffectChance;
    @Config.Comment(value={"Disables advancements (can be used to stop log spam when recipes are tweaked)"})
    public static boolean disableAdvancements;
    @Config.Comment(value={"Mutes errors caused by broken advancements (can be used to stop log spam when recipes are tweaked)"})
    public static boolean muteErroringAdvancements;
    @Config.Comment(value={"Prevents lightning strikes from destroying items"})
    public static boolean disableLightningItemDamage;
    @Config.Comment(value={"Prevents Tough As Nails from creating an extra attack entity event"})
    @Config.RequiresMcRestart
    public static boolean preventTANAttackEntityEvent;
    @Config.Comment(value={"A list of block drop % chances"})
    @Config.Name(value="DropChances")
    public static Map<String, Integer> dropChances;
    @Config.Comment(value={"A list of block effect % chances"})
    @Config.Name(value="EffectChances")
    public static Map<String, Integer> effectChances;
    @Config.Comment(value={"A list of tools/armor and there new repair item (note: only list one tool of a given 'ToolMaterial')"})
    @Config.Name(value="RepairFixes")
    public static Map<String, String> repairFixes;
    @Config.Comment(value={"A list of items that need to do extra damage to undead enemies"})
    @Config.Name(value="ExtraUndeadDamage")
    public static Map<String, Float> extraUndeadDamage;

    static {
        defaultDropChance = 100;
        defaultEffectChance = 100;
        disableAdvancements = false;
        muteErroringAdvancements = false;
        disableLightningItemDamage = false;
        preventTANAttackEntityEvent = true;
        distanceOverrides = new LinkedHashMap<String, Integer>();
        distanceOverrides.put("iceandfire:firedragon", 256);
        distanceOverrides.put("iceandfire:icedragon", 256);
        distanceOverrides.put("iceandfire:seaserpent", 256);
        distanceOverrides.put("iceandfire:cyclops", 256);
        distanceOverrides.put("battletower:golem", 256);
        dropChances = new LinkedHashMap<String, Integer>();
        dropChances.put("iceandfire:ash", 2);
        dropChances.put("iceandfire:chared_cobblestone", 2);
        dropChances.put("iceandfire:chared_stone", 2);
        dropChances.put("iceandfire:chared_grass", 2);
        dropChances.put("iceandfire:chared_dirt", 2);
        dropChances.put("iceandfire:chared_gravel", 2);
        dropChances.put("iceandfire:chared_grass_path", 2);
        dropChances.put("minecraft:cobblestone", 3);
        dropChances.put("minecraft:dirt", 3);
        dropChances.put("minecraft:grass", 4);
        dropChances.put("minecraft:sand", 3);
        dropChances.put("minecraft:stone", 2);
        dropChances.put("iceandfire:frozen_cobblestone", 2);
        dropChances.put("iceandfire:frozen_stone", 2);
        dropChances.put("iceandfire:frozen_grass", 2);
        dropChances.put("iceandfire:frozen_dirt", 2);
        dropChances.put("iceandfire:frozen_gravel", 2);
        dropChances.put("iceandfire:frozen_grass_path", 2);
        dropChances.put("iceandfire:frozen_splinters", 2);
        effectChances = new LinkedHashMap<String, Integer>();
        effectChances.put("iceandfire:ash", 5);
        effectChances.put("iceandfire:chared_cobblestone", 5);
        effectChances.put("iceandfire:chared_stone", 5);
        effectChances.put("iceandfire:chared_dirt", 5);
        effectChances.put("iceandfire:chared_gravel", 5);
        effectChances.put("minecraft:dirt", 5);
        effectChances.put("minecraft:stone", 5);
        effectChances.put("iceandfire:frozen_cobblestone", 5);
        effectChances.put("iceandfire:frozen_stone", 5);
        effectChances.put("iceandfire:frozen_dirt", 5);
        effectChances.put("iceandfire:frozen_gravel", 5);
        effectChances.put("iceandfire:frozen_splinters", 5);
        repairFixes = new LinkedHashMap<String, String>();
        repairFixes.put("aquaculture:neptunium_pickaxe", "aquaculture:loot,1");
        repairFixes.put("aquaculture:neptunium_chestplate", "aquaculture:loot,1");
        extraUndeadDamage = new LinkedHashMap<String, Float>();
        extraUndeadDamage.put("minecraft:bedrock", Float.valueOf(100.0f));
    }
}

