/*
 * Decompiled with CFR 0.152.
 */
package lumberwizard.anvilpatch;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Loader;

@Config(modid="anvilpatch")
public class ModConfig {
    @Config.Ignore
    public static boolean valuesOverriden = false;
    @Config.Comment(value={"Set to -1 to remove the cap.", "This setting will be ignored if Apotheosis is installed."})
    @Config.Name(value="New level cap")
    @Config.RangeInt(min=-1)
    public static int levelCap;
    @Config.Ignore
    public static int syncedLevelCap;
    @Config.Comment(value={"Valid values:", "KEEP - keeps the cumulative repair cost, same as vanilla", "REMOVE_REPAIR_SCALING - repairs won't increase the xp cost, but enchantments will, even for repaired items", "ENCHANTMENT - repairs will always cost the same, but applying more enchantments will cost more", "REMOVE - removes the cumulative repair cost entirely"})
    @Config.Name(value="XP cost increase")
    public static EnumCostIncreaseSetting costIncreaseSetting;
    @Config.Ignore
    public static EnumCostIncreaseSetting syncedCostIncreaseSetting;

    public static int getLevelCap() {
        if (Loader.isModLoaded((String)"apotheosis")) {
            return -1;
        }
        if (valuesOverriden) {
            return syncedLevelCap;
        }
        return levelCap;
    }

    public static EnumCostIncreaseSetting getCostIncreaseSetting() {
        if (valuesOverriden) {
            return syncedCostIncreaseSetting;
        }
        return costIncreaseSetting;
    }

    static {
        syncedLevelCap = levelCap = -1;
        costIncreaseSetting = EnumCostIncreaseSetting.REMOVE_REPAIR_SCALING;
    }

    public static enum EnumCostIncreaseSetting {
        KEEP,
        REMOVE_REPAIR_SCALING,
        ENCHANTMENT_ONLY,
        REMOVE;

    }
}

