/*
 * Decompiled with CFR 0.152.
 */
package lumberwizard.anvilpatch.common;

import java.util.Map;
import lumberwizard.anvilpatch.ModConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="anvilpatch")
public class AnvilEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void anvilUpdate(AnvilUpdateEvent event) {
        int totalRepairCost;
        if (!event.getOutput().func_190926_b()) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack outputItem = left.func_77946_l();
        int addedRepairCost = 0;
        Map outputItemEnchantments = EnchantmentHelper.func_82781_a((ItemStack)outputItem);
        boolean isRightItemEnchantedBook = right.func_77973_b() == Items.field_151134_bR && !ItemEnchantedBook.func_92110_g((ItemStack)right).func_82582_d();
        boolean shouldIncreaseCost = ModConfig.getCostIncreaseSetting() == ModConfig.EnumCostIncreaseSetting.KEEP;
        boolean shouldApplyIncreasedCost = ModConfig.getCostIncreaseSetting() != ModConfig.EnumCostIncreaseSetting.REMOVE;
        int materialCost = 1;
        if (outputItem.func_77984_f() && outputItem.func_77973_b().func_82789_a(left, right)) {
            int amountRepairedByMat = Math.min(outputItem.func_77952_i(), outputItem.func_77958_k() / 4);
            if (amountRepairedByMat <= 0) {
                return;
            }
            for (materialCost = 0; amountRepairedByMat > 0 && materialCost < right.func_190916_E(); ++materialCost) {
                int newDamage = outputItem.func_77952_i() - amountRepairedByMat;
                outputItem.func_77964_b(newDamage);
                ++addedRepairCost;
                amountRepairedByMat = Math.min(outputItem.func_77952_i(), outputItem.func_77958_k() / 4);
            }
        } else {
            if (!(isRightItemEnchantedBook || outputItem.func_77973_b() == right.func_77973_b() && outputItem.func_77984_f())) {
                return;
            }
            if (outputItem.func_77984_f() && !isRightItemEnchantedBook) {
                int leftDurability = left.func_77958_k() - left.func_77952_i();
                int rightDurability = right.func_77958_k() - right.func_77952_i();
                int newDurability = leftDurability + rightDurability + outputItem.func_77958_k() * 12 / 100;
                int newDamage = outputItem.func_77958_k() - newDurability;
                if (newDamage < 0) {
                    newDamage = 0;
                }
                if (newDamage < outputItem.func_77952_i()) {
                    outputItem.func_77964_b(newDamage);
                    addedRepairCost += 2;
                }
            }
            Map enchantmentsToApply = EnchantmentHelper.func_82781_a((ItemStack)right);
            boolean rightItemHasCompatibleEnchantments = false;
            boolean rightItemHasIncompatibleEnchantments = false;
            for (Enchantment enchantmentToAdd : enchantmentsToApply.keySet()) {
                if (enchantmentToAdd == null) continue;
                int currentEnchantmentLevel = outputItemEnchantments.containsKey(enchantmentToAdd) ? (Integer)outputItemEnchantments.get(enchantmentToAdd) : 0;
                int enchantmentNewLevel = (Integer)enchantmentsToApply.get(enchantmentToAdd);
                enchantmentNewLevel = currentEnchantmentLevel == enchantmentNewLevel ? enchantmentNewLevel + 1 : Math.max(enchantmentNewLevel, currentEnchantmentLevel);
                boolean canEnchantmentBeAppliedToLeftItem = enchantmentToAdd.func_92089_a(left);
                if (left.func_77973_b() == Items.field_151134_bR) {
                    canEnchantmentBeAppliedToLeftItem = true;
                }
                for (Enchantment enchantment : outputItemEnchantments.keySet()) {
                    if (enchantment == enchantmentToAdd || enchantmentToAdd.func_191560_c(enchantment)) continue;
                    canEnchantmentBeAppliedToLeftItem = false;
                    ++addedRepairCost;
                }
                if (!canEnchantmentBeAppliedToLeftItem) {
                    rightItemHasIncompatibleEnchantments = true;
                    continue;
                }
                rightItemHasCompatibleEnchantments = true;
                if (enchantmentNewLevel > enchantmentToAdd.func_77325_b()) {
                    enchantmentNewLevel = enchantmentToAdd.func_77325_b();
                }
                outputItemEnchantments.put(enchantmentToAdd, enchantmentNewLevel);
                int repairCostAddedByEnchantmentRarity = 0;
                switch (enchantmentToAdd.func_77324_c()) {
                    case COMMON: {
                        repairCostAddedByEnchantmentRarity = 1;
                        break;
                    }
                    case UNCOMMON: {
                        repairCostAddedByEnchantmentRarity = 2;
                        break;
                    }
                    case RARE: {
                        repairCostAddedByEnchantmentRarity = 4;
                        break;
                    }
                    case VERY_RARE: {
                        repairCostAddedByEnchantmentRarity = 8;
                    }
                }
                if (isRightItemEnchantedBook) {
                    repairCostAddedByEnchantmentRarity = Math.max(1, repairCostAddedByEnchantmentRarity / 2);
                }
                addedRepairCost += repairCostAddedByEnchantmentRarity * enchantmentNewLevel;
                if (left.func_190916_E() <= 1) continue;
                return;
            }
            if (rightItemHasIncompatibleEnchantments && !rightItemHasCompatibleEnchantments) {
                return;
            }
            shouldIncreaseCost = shouldIncreaseCost || rightItemHasCompatibleEnchantments && ModConfig.getCostIncreaseSetting() != ModConfig.EnumCostIncreaseSetting.REMOVE;
            shouldApplyIncreasedCost = shouldApplyIncreasedCost && (rightItemHasCompatibleEnchantments || ModConfig.getCostIncreaseSetting() != ModConfig.EnumCostIncreaseSetting.ENCHANTMENT_ONLY);
        }
        int renameAddedCost = 0;
        String repairedItemName = event.getName();
        if (StringUtils.isBlank((CharSequence)repairedItemName)) {
            if (left.func_82837_s()) {
                renameAddedCost = 1;
                addedRepairCost += renameAddedCost;
                outputItem.func_135074_t();
            }
        } else if (!repairedItemName.equals(left.func_82833_r())) {
            renameAddedCost = 1;
            addedRepairCost += renameAddedCost;
            outputItem.func_151001_c(repairedItemName);
        }
        if (isRightItemEnchantedBook && !outputItem.func_77973_b().isBookEnchantable(outputItem, right)) {
            outputItem = ItemStack.field_190927_a;
        }
        if ((totalRepairCost = (shouldApplyIncreasedCost ? event.getCost() : 0) + addedRepairCost) <= 0) {
            outputItem = ItemStack.field_190927_a;
        }
        if (addedRepairCost == renameAddedCost && ModConfig.getLevelCap() >= 0 && totalRepairCost >= ModConfig.getLevelCap()) {
            totalRepairCost = ModConfig.getLevelCap() - 1;
        }
        if (ModConfig.getLevelCap() >= 0 && totalRepairCost >= ModConfig.getLevelCap()) {
            if (event.getOutput().func_190926_b()) {
                event.setCanceled(true);
            }
            return;
        }
        if (!outputItem.func_190926_b()) {
            if (shouldIncreaseCost) {
                int newCost = outputItem.func_82838_A();
                if (!right.func_190926_b() && newCost < right.func_82838_A()) {
                    newCost = right.func_82838_A();
                }
                if (renameAddedCost != addedRepairCost || renameAddedCost == 0) {
                    newCost = newCost * 2 + 1;
                }
                outputItem.func_82841_c(newCost);
            }
            EnchantmentHelper.func_82782_a((Map)outputItemEnchantments, (ItemStack)outputItem);
            if (outputItem.func_77984_f() && outputItem.func_77973_b().func_82789_a(left, right)) {
                event.setMaterialCost(materialCost);
            }
            event.setCost(totalRepairCost);
            event.setOutput(outputItem);
        }
    }
}

