/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.base;

import codersafterdark.reskillable.api.ReskillableAPI;
import codersafterdark.reskillable.api.data.FuzzyLockKey;
import codersafterdark.reskillable.api.data.GenericLockKey;
import codersafterdark.reskillable.api.data.GenericNBTLockKey;
import codersafterdark.reskillable.api.data.ItemInfo;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.api.data.ModLockKey;
import codersafterdark.reskillable.api.data.ParentLockKey;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.ConfigHandler;
import codersafterdark.reskillable.base.ToolTipHandler;
import codersafterdark.reskillable.network.MessageLockedItem;
import codersafterdark.reskillable.network.PacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class LevelLockHandler {
    public static final String[] DEFAULT_SKILL_LOCKS = new String[]{"minecraft:iron_shovel:*=reskillable:gathering|5", "minecraft:iron_axe:*=reskillable:gathering|5", "minecraft:iron_sword:*=reskillable:attack|5", "minecraft:iron_pickaxe:*=reskillable:mining|5", "minecraft:iron_hoe:*=reskillable:farming|5", "minecraft:iron_helmet:*=reskillable:defense|5", "minecraft:iron_chestplate:*=reskillable:defense|5", "minecraft:iron_leggings:*=reskillable:defense|5", "minecraft:iron_boots:*=reskillable:defense|5", "minecraft:golden_shovel:*=reskillable:gathering|5,reskillable:magic|5", "minecraft:golden_axe:*=reskillable:gathering|5,reskillable:magic|5", "minecraft:golden_sword:*=reskillable:attack|5,reskillable:magic|5", "minecraft:golden_pickaxe:*=reskillable:mining|5,reskillable:magic|5", "minecraft:golden_hoe:*=reskillable:farming|5,reskillable:magic|5", "minecraft:golden_helmet:*=reskillable:defense|5,reskillable:magic|5", "minecraft:golden_chestplate:*=reskillable:defense|5,reskillable:magic|5", "minecraft:golden_leggings:*=reskillable:defense|5,reskillable:magic|5", "minecraft:golden_boots:*=reskillable:defense|5,reskillable:magic|5", "minecraft:diamond_shovel:*=reskillable:gathering|16", "minecraft:diamond_axe:*=reskillable:gathering|16", "minecraft:diamond_sword:*=reskillable:attack|16", "minecraft:diamond_pickaxe:*=reskillable:mining|16", "minecraft:diamond_hoe:*=reskillable:farming|16", "minecraft:diamond_helmet:*=reskillable:defense|16", "minecraft:diamond_chestplate:*=reskillable:defense|16", "minecraft:diamond_leggings:*=reskillable:defense|16", "minecraft:diamond_boots:*=reskillable:defense|16", "minecraft:shears:*=reskillable:farming|5,reskillable:gathering|5", "minecraft:fishing_rod:*=reskillable:gathering|8", "minecraft:shield:*=reskillable:defense|8", "minecraft:bow:*=reskillable:attack|8", "minecraft:ender_pearl=reskillable:magic|8", "minecraft:ender_eye=reskillable:magic|16,reskillable:building|8", "minecraft:elytra:*=reskillable:defense|16,reskillable:agility|24,reskillable:magic|16", "minecraft:lead=reskillable:farming|5", "minecraft:end_crystal=reskillable:building|24,reskillable:magic|32", "minecraft:iron_horse_armor:*=reskillable:defense|5,reskillable:agility|5", "minecraft:golden_horse_armor:*=reskillable:defense|5,reskillable:magic|5,reskillable:agility|5", "minecraft:diamond_horse_armor:*=reskillable:defense|16,reskillable:agility|16", "minecraft:fireworks=reskillable:agility|24", "minecraft:dye:15=reskillable:farming|12", "minecraft:saddle=reskillable:agility|12", "minecraft:redstone=reskillable:building|5", "minecraft:redstone_torch=reskillable:building|5", "minecraft:skull:1=reskillable:building|20,reskillable:attack|20,reskillable:defense|20"};
    private static final Map<LockKey, RequirementHolder> locks = new HashMap<LockKey, RequirementHolder>();
    public static RequirementHolder EMPTY_LOCK = new RequirementHolder();
    private static Map<Class<?>, List<Class<? extends LockKey>>> lockTypesMap = new HashMap();
    private static Map<LockKey, Set<FuzzyLockKey>> fuzzyLockInfo = new HashMap<LockKey, Set<FuzzyLockKey>>();
    private static String[] configLocks;

    public static void loadFromConfig(String[] configValues) {
        configLocks = configValues;
    }

    public static void setupLocks() {
        LevelLockHandler.registerDefaultLockKeys();
        if (configLocks != null) {
            for (String s : configLocks) {
                Item item;
                String[] tokens = s.split("=");
                if (tokens.length != 2) continue;
                String itemName = tokens[0].toLowerCase();
                String[] itemParts = itemName.split(":");
                if (itemParts.length == 1) {
                    LevelLockHandler.addModLock(itemName, RequirementHolder.fromString(tokens[1]));
                    continue;
                }
                int metadata = 0;
                if (itemParts.length > 2) {
                    String meta = itemParts[2];
                    try {
                        metadata = meta.equals("*") ? Short.MAX_VALUE : Integer.parseInt(meta);
                        itemName = itemParts[0] + ':' + itemParts[1];
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((item = Item.func_111206_d((String)itemName)) == null) continue;
                LevelLockHandler.addLock(new ItemStack(item, 1, metadata), RequirementHolder.fromString(tokens[1]));
            }
        }
    }

    private static void registerDefaultLockKeys() {
        LevelLockHandler.registerLockKey(ItemStack.class, ItemInfo.class, ModLockKey.class, GenericNBTLockKey.class);
    }

    public static void registerLockKey(Class<?> lockTypeClass, Class<? extends LockKey> ... keyClasses) {
        for (Class<? extends LockKey> keyClass : keyClasses) {
            try {
                keyClass.getDeclaredConstructor(lockTypeClass);
                lockTypesMap.computeIfAbsent(lockTypeClass, k -> new ArrayList()).add(keyClass);
            }
            catch (NoSuchMethodException | SecurityException e) {
                ReskillableAPI.getInstance().log(Level.ERROR, keyClass.getSimpleName() + " does not have a constructor with the parameter: " + lockTypeClass.getSimpleName());
            }
        }
    }

    public static void addLockByKey(LockKey key, RequirementHolder holder) {
        FuzzyLockKey fuzzy;
        if (key == null || key instanceof GenericLockKey) {
            return;
        }
        if (holder == null || holder.equals(EMPTY_LOCK) || holder.getRestrictionLength() == 0) {
            return;
        }
        locks.put(key, holder);
        if (key instanceof FuzzyLockKey && !(fuzzy = (FuzzyLockKey)key).isNotFuzzy()) {
            LockKey without = fuzzy.getNotFuzzy();
            if (without == null) {
                without = new GenericLockKey(key.getClass());
            }
            fuzzyLockInfo.computeIfAbsent(without, k -> new HashSet()).add(fuzzy);
        }
        ToolTipHandler.resetLast();
    }

    public static void addModLock(String modName, RequirementHolder holder) {
        LevelLockHandler.addLockByKey(new ModLockKey(modName), holder);
    }

    public static void addLock(ItemStack stack, RequirementHolder holder) {
        LevelLockHandler.addLockByKey(new ItemInfo(stack), holder);
    }

    public static RequirementHolder getLockByKey(LockKey key) {
        RequirementHolder holder;
        if (locks.containsKey(key) && !(holder = locks.get(key)).hasNone()) {
            return holder;
        }
        return EMPTY_LOCK;
    }

    public static RequirementHolder getLockByFuzzyKey(FuzzyLockKey key) {
        List<RequirementHolder> requirements = LevelLockHandler.getFuzzyRequirements(key);
        if (requirements.isEmpty()) {
            return EMPTY_LOCK;
        }
        RequirementHolder holder = new RequirementHolder(requirements.toArray(new RequirementHolder[0]));
        return holder.hasNone() ? EMPTY_LOCK : holder;
    }

    private static List<RequirementHolder> getFuzzyRequirements(FuzzyLockKey key) {
        ArrayList<RequirementHolder> requirements = new ArrayList<RequirementHolder>();
        if (!key.isNotFuzzy()) {
            LockKey baseLock = key.getNotFuzzy();
            if (baseLock == null) {
                baseLock = new GenericLockKey(key.getClass());
            } else if (locks.containsKey(baseLock)) {
                RequirementHolder holder = locks.get(baseLock);
                if (holder.hasNone()) {
                    return Collections.singletonList(holder);
                }
                requirements.add(holder);
            }
            Set<FuzzyLockKey> fuzzyLookup = fuzzyLockInfo.get(baseLock);
            if (fuzzyLookup != null) {
                for (FuzzyLockKey fuzzyLock : fuzzyLookup) {
                    if (!key.fuzzyEquals(fuzzyLock) || !locks.containsKey(fuzzyLock)) continue;
                    RequirementHolder holder = locks.get(fuzzyLock);
                    if (holder.hasNone()) {
                        return Collections.singletonList(holder);
                    }
                    requirements.add(holder);
                }
            }
        } else if (locks.containsKey(key)) {
            RequirementHolder holder = locks.get(key);
            if (holder.hasNone()) {
                return Collections.singletonList(holder);
            }
            requirements.add(holder);
        }
        return requirements;
    }

    public static RequirementHolder getSkillLock(ItemStack stack) {
        return stack == null || stack.func_190926_b() ? EMPTY_LOCK : LevelLockHandler.getLocks(ItemStack.class, stack);
    }

    @SafeVarargs
    public static <T> RequirementHolder getLocks(Class<? extends T> classType, T ... tToCheck) {
        if (tToCheck == null || tToCheck.length == 0 || !lockTypesMap.containsKey(classType)) {
            return EMPTY_LOCK;
        }
        List<Class<? extends LockKey>> lockTypes = lockTypesMap.get(classType);
        ArrayList<RequirementHolder> requirements = new ArrayList<RequirementHolder>();
        for (T toCheck : tToCheck) {
            for (Class<? extends LockKey> keyClass : lockTypes) {
                RequirementHolder subLocks;
                LockKey lock;
                try {
                    lock = keyClass.getDeclaredConstructor(classType).newInstance(toCheck);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    continue;
                }
                if (lock instanceof FuzzyLockKey) {
                    requirements.addAll(LevelLockHandler.getFuzzyRequirements((FuzzyLockKey)lock));
                } else if (locks.containsKey(lock)) {
                    RequirementHolder holder = locks.get(lock);
                    if (holder.hasNone()) {
                        return EMPTY_LOCK;
                    }
                    requirements.add(holder);
                }
                if (!(lock instanceof ParentLockKey) || (subLocks = ((ParentLockKey)lock).getSubRequirements()) == null || subLocks.equals(EMPTY_LOCK)) continue;
                if (subLocks.hasNone()) {
                    return EMPTY_LOCK;
                }
                requirements.add(subLocks);
            }
        }
        if (requirements.isEmpty()) {
            return EMPTY_LOCK;
        }
        RequirementHolder holder = new RequirementHolder(requirements.toArray(new RequirementHolder[0]));
        return holder.hasNone() ? EMPTY_LOCK : holder;
    }

    public static boolean canPlayerUseItem(EntityPlayer player, ItemStack stack) {
        RequirementHolder lock = LevelLockHandler.getSkillLock(stack);
        return lock.equals(EMPTY_LOCK) || PlayerDataHandler.get(player).matchStats(lock);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void hurtEvent(LivingAttackEvent event) {
        if (!event.isCanceled() && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            LevelLockHandler.genericEnforce((Event)event, player, player.func_184614_ca(), "reskillable.misc.locked.item");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void leftClick(PlayerInteractEvent.LeftClickBlock event) {
        TileEntity te;
        LevelLockHandler.enforce((PlayerInteractEvent)event);
        if (event.isCanceled()) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        if (stack.func_190926_b()) {
            stack = block.func_185473_a(event.getWorld(), event.getPos(), state);
        }
        if (block.hasTileEntity(state) && (te = event.getWorld().func_175625_s(event.getPos())) != null && !te.func_145837_r()) {
            stack.func_77982_d(te.func_189515_b(new NBTTagCompound()));
        }
        LevelLockHandler.genericEnforce((Event)event, event.getEntityPlayer(), stack, "reskillable.misc.locked.block_break");
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        LevelLockHandler.enforce((PlayerInteractEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity te;
        IBlockState state;
        Block block;
        ItemStack stack;
        LevelLockHandler.enforce((PlayerInteractEvent)event);
        if (event.isCanceled()) {
            return;
        }
        if (event.getItemStack().func_190926_b()) {
            EntityPlayer player = event.getEntityPlayer();
            LevelLockHandler.genericEnforce((Event)event, player, event.getHand().equals((Object)EnumHand.MAIN_HAND) ? player.func_184592_cb() : player.func_184614_ca(), "reskillable.misc.locked.item");
            if (event.isCanceled()) {
                return;
            }
        }
        if ((stack = new ItemStack(block = (state = event.getWorld().func_180495_p(event.getPos())).func_177230_c(), 1, state.func_177230_c().func_176201_c(state))).func_190926_b()) {
            stack = block.func_185473_a(event.getWorld(), event.getPos(), state);
        }
        if (block.hasTileEntity(state) && (te = event.getWorld().func_175625_s(event.getPos())) != null && !te.func_145837_r()) {
            stack.func_77982_d(te.func_189515_b(new NBTTagCompound()));
        }
        LevelLockHandler.genericEnforce((Event)event, event.getEntityPlayer(), stack, "reskillable.misc.locked.block_use");
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        TileEntity te;
        if (event.isCanceled()) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        if (state.func_177230_c().hasTileEntity(state) && (te = event.getWorld().func_175625_s(event.getPos())) != null && !te.func_145837_r()) {
            stack.func_77982_d(te.func_189515_b(new NBTTagCompound()));
        }
        LevelLockHandler.genericEnforce((Event)event, event.getPlayer(), stack, "reskillable.misc.locked.block_break");
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void entityInteract(PlayerInteractEvent.EntityInteract event) {
        LevelLockHandler.enforce((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onArmorEquip(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ItemStack stack;
            EntityEquipmentSlot slot;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!(!ConfigHandler.enforceOnCreative && player.func_184812_l_() || LevelLockHandler.isFake((Entity)player) || !(slot = event.getSlot()).func_188453_a().equals((Object)EntityEquipmentSlot.Type.ARMOR) || LevelLockHandler.canPlayerUseItem(player, stack = (ItemStack)player.field_71071_by.field_70460_b.get(slot.func_188454_b())))) {
                if (!player.field_71071_by.func_70441_a(stack)) {
                    player.func_71019_a(stack, false);
                }
                player.field_71071_by.field_70460_b.set(slot.func_188454_b(), (Object)ItemStack.field_190927_a);
                LevelLockHandler.tellPlayer(player, stack, "reskillable.misc.locked.armor_equip");
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && ConfigHandler.disableSheepWool && event.getEntity() instanceof EntitySheep) {
            event.getDrops().removeIf(e -> e.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L));
        }
    }

    public static boolean isFake(Entity e) {
        return e instanceof FakePlayer;
    }

    public static void enforce(PlayerInteractEvent event) {
        LevelLockHandler.genericEnforce((Event)event, event.getEntityPlayer(), event.getItemStack(), "reskillable.misc.locked.item");
    }

    public static void genericEnforce(Event event, EntityPlayer player, ItemStack stack, String lockMessage) {
        if (!event.isCancelable() || event.isCanceled() || player == null || stack == null || stack.func_190926_b() || !ConfigHandler.enforceOnCreative && player.func_184812_l_()) {
            return;
        }
        if (ConfigHandler.enforceFakePlayers) {
            if (!LevelLockHandler.canPlayerUseItem(player, stack)) {
                event.setCanceled(true);
                if (!LevelLockHandler.isFake((Entity)player)) {
                    LevelLockHandler.tellPlayer(player, stack, lockMessage);
                }
            }
        } else if (!LevelLockHandler.isFake((Entity)player) && !LevelLockHandler.canPlayerUseItem(player, stack)) {
            LevelLockHandler.tellPlayer(player, stack, lockMessage);
            event.setCanceled(true);
        }
    }

    public static void tellPlayer(EntityPlayer player, ItemStack stack, String msg) {
        if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageLockedItem(stack, msg), (EntityPlayerMP)player);
        }
    }
}

