/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.enchantments;

import com.mujmajnkraft.bettersurvival.config.ConfigHandler;
import com.mujmajnkraft.bettersurvival.items.ItemBattleAxe;
import com.mujmajnkraft.bettersurvival.items.ItemDagger;
import com.mujmajnkraft.bettersurvival.items.ItemHammer;
import com.mujmajnkraft.bettersurvival.items.ItemNunchaku;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class EnchantmentSpecialBonus
extends Enchantment {
    private EnumWeaponType weapon;

    public EnchantmentSpecialBonus(EnumWeaponType class1) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.weapon = class1;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 9;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 15;
    }

    public int func_77325_b() {
        switch (this.weapon) {
            case DAGGER: {
                return ConfigHandler.assassinatelevel;
            }
            case NUNCHAKU: {
                return ConfigHandler.combolevel;
            }
            case HAMMER: {
                return ConfigHandler.bashlevel;
            }
            case BATTLEAXE: {
                return ConfigHandler.disarmlevel;
            }
        }
        return 3;
    }

    public boolean isAllowedOnBooks() {
        switch (this.weapon) {
            case DAGGER: {
                return ConfigHandler.assassinatelevel != 0;
            }
            case NUNCHAKU: {
                return ConfigHandler.combolevel != 0;
            }
            case HAMMER: {
                return ConfigHandler.bashlevel != 0;
            }
            case BATTLEAXE: {
                return ConfigHandler.disarmlevel != 0;
            }
        }
        return super.isAllowedOnBooks();
    }

    public boolean func_185261_e() {
        switch (this.weapon) {
            case DAGGER: {
                return ConfigHandler.assassinate;
            }
            case NUNCHAKU: {
                return ConfigHandler.combo;
            }
            case HAMMER: {
                return ConfigHandler.bash;
            }
            case BATTLEAXE: {
                return ConfigHandler.disarm;
            }
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        switch (this.weapon) {
            case DAGGER: {
                return stack.func_77973_b() instanceof ItemDagger;
            }
            case NUNCHAKU: {
                return stack.func_77973_b() instanceof ItemNunchaku;
            }
            case HAMMER: {
                return stack.func_77973_b() instanceof ItemHammer;
            }
            case BATTLEAXE: {
                return stack.func_77973_b() instanceof ItemBattleAxe;
            }
        }
        return false;
    }

    public static enum EnumWeaponType {
        DAGGER,
        NUNCHAKU,
        BATTLEAXE,
        HAMMER;

    }
}

