/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.entities.siegeweapons;

import com.mujmajnkraft.bettersurvival.entities.siegeweapons.EntityZeppelin;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntitySiegeWeapon
extends Entity {
    protected boolean leftInputDown;
    protected boolean rightInputDown;
    protected boolean forwardInputDown;
    protected boolean backwardInputDown;
    protected boolean upInputDown;
    protected boolean downInputDown;
    protected boolean actionInputPressed;
    private float deltaRotation;
    public boolean isPullable;
    public float durability;

    public EntitySiegeWeapon(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_184232_k(Entity passenger) {
        passenger.field_70177_z += this.deltaRotation;
        passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        this.applyYawToEntity(passenger);
        super.func_184232_k(passenger);
    }

    public Entity func_184179_bs() {
        if (!this.func_184188_bt().isEmpty()) {
            return (Entity)this.func_184188_bt().get(0);
        }
        return super.func_184179_bs();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (this.func_184207_aI()) {
            return true;
        }
        boolean leashed = false;
        List list = this.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(this.field_70165_t - 7.0, this.field_70163_u - 7.0, this.field_70161_v - 7.0, this.field_70165_t + 7.0, this.field_70163_u + 7.0, this.field_70161_v + 7.0));
        for (EntityLiving entityliving1 : list) {
            if (!entityliving1.func_110167_bD() || entityliving1.func_110166_bE() != this) continue;
            leashed = true;
        }
        if (!this.field_70170_p.field_72995_K && !leashed) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateInputs(boolean left, boolean right, boolean forward, boolean backward, boolean up, boolean down) {
        this.leftInputDown = left;
        this.rightInputDown = right;
        this.forwardInputDown = forward;
        this.backwardInputDown = backward;
        this.upInputDown = up;
        this.downInputDown = down;
    }

    public void performAction() {
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            this.durability -= amount;
            System.out.println(amount);
            System.out.println(this.durability);
            if (this.durability <= 0.0f) {
                this.func_70106_y();
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70030_z() {
        this.field_70181_x += this.func_189652_ae() ? 0.0 : (double)-0.04f;
        if (this.func_184179_bs() != null && this.field_70170_p.field_72995_K) {
            this.Control();
        }
        List list = this.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(this.field_70165_t - 7.0, this.field_70163_u - 7.0, this.field_70161_v - 7.0, this.field_70165_t + 7.0, this.field_70163_u + 7.0, this.field_70161_v + 7.0));
        for (EntityLiving entityliving1 : list) {
            if (!entityliving1.func_110167_bD() || entityliving1.func_110166_bE() != this) continue;
            double x = Math.max(this.func_70068_e((Entity)entityliving1) - 2.0, 0.0);
            double dx = entityliving1.field_70165_t - this.field_70165_t;
            double dz = entityliving1.field_70161_v - this.field_70161_v;
            this.field_70159_w = dx * (x / 10.0);
            this.field_70179_y = dz * (x / 10.0);
            if (dz < 0.0) {
                this.field_70177_z = (float)(-Math.toDegrees(Math.atan((this.field_70165_t - entityliving1.field_70165_t) / (this.field_70161_v - entityliving1.field_70161_v))));
                continue;
            }
            this.field_70177_z = (float)(-Math.toDegrees(Math.atan((this.field_70165_t - entityliving1.field_70165_t) / (this.field_70161_v - entityliving1.field_70161_v)))) + 180.0f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.9f;
        this.field_70181_x *= (double)0.9f;
        this.field_70179_y *= (double)0.9f;
        this.deltaRotation *= 0.5f;
        super.func_70030_z();
    }

    private void Control() {
        float f = 0.0f;
        if (this.leftInputDown) {
            this.deltaRotation += -1.0f;
        }
        if (this.rightInputDown) {
            this.deltaRotation += 1.0f;
        }
        if (this.forwardInputDown) {
            f += 0.005f;
        }
        if (this.backwardInputDown) {
            f += -0.003f;
        }
        if (this instanceof EntityZeppelin) {
            if (this.upInputDown && this.forwardInputDown && this.field_70163_u < 120.0) {
                this.field_70181_x += (double)0.005f;
            }
            if (this.downInputDown && this.forwardInputDown) {
                this.field_70181_x -= (double)0.005f;
            }
        }
        this.field_70177_z += this.deltaRotation;
        this.func_184179_bs().field_70177_z = this.field_70177_z;
        this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f);
        this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f);
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("Durability", this.durability);
    }

    public void readEntityToNBT(NBTTagCompound compound) {
        this.durability = compound.func_74760_g("Durability");
    }
}

