/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.loot;

import cursedflames.bountifulbaubles.BountifulBaubles;
import cursedflames.bountifulbaubles.ModConfig;
import cursedflames.bountifulbaubles.item.ModItems;
import cursedflames.bountifulbaubles.util.Config;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModLoot {
    static Property dungeon_baseRate;
    static Property dungeon_potionRate;
    static Property wormholeEnabled;
    static Property nether_baseRate;
    static Property nether_potionRate;

    public static void initConfig() {
        dungeon_baseRate = BountifulBaubles.config.addPropDouble("dungeon_base", ModConfig.CAT_LOOT, "Chance of a BountifulBaubles item spawning in a dungeon chest (excluding recall/wormhole potions). 0 to disable.", 0.35, Config.EnumPropSide.SERVER, 0.0, 1.0);
        dungeon_potionRate = BountifulBaubles.config.addPropDouble("dungeon_potion", ModConfig.CAT_LOOT, "Chance of recall or wormhole potions spawning in a dungeon chest. 0 to disable.", 0.75, Config.EnumPropSide.SERVER, 0.0, 1.0);
        wormholeEnabled = BountifulBaubles.config.addPropBoolean("wormhole", ModConfig.CAT_LOOT, "Whether or not wormhole potions generate in dungeon chests. \nYou may want to disable this if only playing singleplayer, so you don't get stacks of useless potions", true, Config.EnumPropSide.SERVER);
        nether_baseRate = BountifulBaubles.config.addPropDouble("nether_base", ModConfig.CAT_LOOT, "Chance of a BountifulBaubles item spawning in a nether fortress chest (excluding recall/wormhole potions). 0 to disable.", 0.2, Config.EnumPropSide.SERVER, 0.0, 1.0);
        nether_potionRate = BountifulBaubles.config.addPropDouble("nether_potion", ModConfig.CAT_LOOT, "Chance of recall or wormhole potions or other misc. items spawning in a nether fortress chest. 0 to disable.", 0.1, Config.EnumPropSide.SERVER, 0.0, 1.0);
    }

    @SubscribeEvent
    public static void onLootTablesLoaded(LootTableLoadEvent event) {
        if (ModConfig.mobLootEnabled.getBoolean(true)) {
            LootPool table;
            if (event.getName().equals((Object)LootTableList.field_191182_ar)) {
                table = new LootPool(new LootEntry[]{new LootEntryItem(ModItems.trinketApple, 1, 1, new LootFunction[0], new LootCondition[]{new KilledByPlayer(false)}, "bountifulbaubles:apple")}, new LootCondition[]{new RandomChance(0.025f)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_husk");
                event.getTable().addPool(table);
            } else if (event.getName().equals((Object)LootTableList.field_186441_w)) {
                table = new LootPool(new LootEntry[]{new LootEntryItem(ModItems.trinketVitamins, 1, 1, new LootFunction[0], new LootCondition[]{new KilledByPlayer(false)}, "bountifulbaubles:vitamins")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_elder_guardian");
                event.getTable().addPool(table);
            } else if (event.getName().equals((Object)LootTableList.field_189968_an)) {
                table = new LootPool(new LootEntry[]{new LootEntryItem(ModItems.ringOverclocking, 1, 1, new LootFunction[0], new LootCondition[]{new KilledByPlayer(false)}, "bountifulbaubles:vitamins")}, new LootCondition[]{new RandomChance(0.03f)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_stray");
                event.getTable().addPool(table);
            } else if (event.getName().equals((Object)LootTableList.field_186442_x)) {
                table = new LootPool(new LootEntry[]{new LootEntryItem(ModItems.trinketShulkerHeart, 1, 1, new LootFunction[0], new LootCondition[]{new KilledByPlayer(false)}, "bountifulbaubles:shulkerHeart")}, new LootCondition[]{new RandomChance(0.1f)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_shulker");
                event.getTable().addPool(table);
            } else if (event.getName().equals((Object)LootTableList.field_186436_r)) {
                table = new LootPool(new LootEntry[]{new LootEntryItem(ModItems.trinketBezoar, 1, 1, new LootFunction[0], new LootCondition[]{new KilledByPlayer(false)}, "bountifulbaubles:bezoar")}, new LootCondition[]{new RandomChance(0.05f)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_cave_spider");
                event.getTable().addPool(table);
            }
        }
        if (ModConfig.dungeonLootEnabled.getBoolean(true)) {
            String eventName = event.getName().toString();
            if (eventName.equals("minecraft:chests/simple_dungeon")) {
                double potionRate;
                double baseRate = dungeon_baseRate.getDouble(0.35);
                if (baseRate > 0.0) {
                    Item[] itemsWeight10;
                    ArrayList<Object> entries = new ArrayList<Object>();
                    for (Item item : itemsWeight10 = new Item[]{ModItems.balloon, ModItems.shieldCobalt, ModItems.magicMirror, ModItems.trinketLuckyHorseshoe, ModItems.trinketBrokenHeart, ModItems.trinketMagicLenses, ModItems.amuletCross}) {
                        entries.add(new LootEntryItem(item, 10, 0, new LootFunction[0], new LootCondition[0], item.getRegistryName().toString()));
                    }
                    entries.add(new LootEntryItem(ModItems.brokenBlackDragonScale, 3, 0, new LootFunction[0], new LootCondition[0], ModItems.brokenBlackDragonScale.getRegistryName().toString()));
                    entries.add(new LootEntryItem(ModItems.sinPendantEmpty, 3, 0, new LootFunction[0], new LootCondition[0], ModItems.brokenBlackDragonScale.getRegistryName().toString()));
                    entries.add(new LootEntryItem(ModItems.phantomPrism, 1, 0, new LootFunction[0], new LootCondition[0], ModItems.phantomPrism.getRegistryName().toString()));
                    entries.add(new LootEntryTable(new ResourceLocation("bountifulbaubles", "flare_gun"), 10, 0, new LootCondition[0], ModItems.flareGun.getRegistryName().toString()));
                    LootPool pool = new LootPool(entries.toArray(new LootEntry[0]), new LootCondition[]{new RandomChance((float)baseRate)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_dungeon");
                    event.getTable().addPool(pool);
                }
                if ((potionRate = dungeon_potionRate.getDouble(0.75)) > 0.0) {
                    ArrayList<Object> entries2 = new ArrayList<Object>();
                    entries2.add(new LootEntryItem(ModItems.potionRecall, 50, 0, new LootFunction[0], new LootCondition[0], "bountifulbaubles:potionrecall"));
                    if (wormholeEnabled.getBoolean(true)) {
                        entries2.add(new LootEntryItem(ModItems.potionWormhole, 25, 0, new LootFunction[0], new LootCondition[0], "bountifulbaubles:potionwormhole"));
                    }
                    entries2.add(new LootEntryEmpty(25, 0, new LootCondition[0], "empty"));
                    LootPool pool2 = new LootPool(entries2.toArray(new LootEntry[0]), new LootCondition[]{new RandomChance((float)potionRate)}, new RandomValueRange(1.0f, 6.0f), new RandomValueRange(0.0f), "bountifulbaubles_dungeon_potions");
                    event.getTable().addPool(pool2);
                }
            } else if (eventName.equals("minecraft:chests/nether_bridge")) {
                double miscRate;
                double baseRate = nether_baseRate.getDouble(0.2);
                if (baseRate > 0.0) {
                    Item[] itemsWeight10;
                    ArrayList<LootEntryItem> entries = new ArrayList<LootEntryItem>();
                    for (Item item : itemsWeight10 = new Item[]{ModItems.brokenBlackDragonScale, ModItems.magicMirror, ModItems.trinketObsidianSkull, ModItems.trinketBrokenHeart, ModItems.sinPendantEmpty}) {
                        entries.add(new LootEntryItem(item, 10, 0, new LootFunction[0], new LootCondition[0], item.getRegistryName().toString()));
                    }
                    entries.add(new LootEntryItem(ModItems.phantomPrism, 1, 0, new LootFunction[0], new LootCondition[0], ModItems.phantomPrism.getRegistryName().toString()));
                    LootPool pool = new LootPool(entries.toArray(new LootEntry[0]), new LootCondition[]{new RandomChance((float)baseRate)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_nether_bridge");
                    event.getTable().addPool(pool);
                }
                if ((miscRate = nether_potionRate.getDouble(0.1)) > 0.0) {
                    Item[] entries2 = new ArrayList();
                    entries2.add(new LootEntryItem(ModItems.potionRecall, 5, 0, new LootFunction[0], new LootCondition[0], "bountifulbaubles:potionrecall"));
                    if (wormholeEnabled.getBoolean(true)) {
                        entries2.add(new LootEntryItem(ModItems.potionWormhole, 25, 0, new LootFunction[0], new LootCondition[0], "bountifulbaubles:potionwormhole"));
                    }
                    entries2.add(new LootEntryItem(ModItems.ironRing, 25, 0, new LootFunction[0], new LootCondition[0], "bountifulbaubles:ironring"));
                    LootPool pool2 = new LootPool(entries2.toArray(new LootEntry[0]), new LootCondition[]{new RandomChance((float)miscRate)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "bountifulbaubles_nether_bridge_2");
                    event.getTable().addPool(pool2);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        if (ModConfig.mobLootEnabled.getBoolean(true) && event.getEntity() instanceof EntityDragon && !event.getEntity().field_70170_p.field_72995_K) {
            EntityDragon dragon = (EntityDragon)event.getEntity();
            if (dragon.field_70995_bG == 199) {
                BountifulBaubles.logger.info((Object)dragon.field_70170_p.restoringBlockSnapshots);
                int numScales = dragon.field_70170_p.field_73012_v.nextInt(4) + 3;
                for (int i = 0; i < numScales; ++i) {
                    ItemStack stack = new ItemStack(ModItems.enderDragonScale);
                    double angle = Math.random() * Math.PI * 2.0;
                    double xOff = Math.cos(angle) * 2.0;
                    double zOff = Math.sin(angle) * 2.0;
                    double xVel = xOff * 0.15;
                    double zVel = zOff * 0.15;
                    EntityItem dropped = new EntityItem(dragon.field_70170_p, dragon.field_70165_t + xOff, dragon.field_70163_u, dragon.field_70161_v + zOff, stack);
                    dragon.field_70170_p.func_72838_d((Entity)dropped);
                    dropped.field_70159_w = xVel;
                    dropped.field_70179_y = zVel;
                }
            }
        }
    }
}

