/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.IngredientSet;
import mezz.jei.util.Log;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;

public class IngredientRegistry
implements IIngredientRegistry {
    private final IModIdHelper modIdHelper;
    private final IngredientBlacklistInternal blacklist;
    private final Map<IIngredientType, IngredientSet> ingredientsMap;
    private final ImmutableMap<IIngredientType, IIngredientHelper> ingredientHelperMap;
    private final ImmutableMap<IIngredientType, IIngredientRenderer> ingredientRendererMap;
    private final ImmutableMap<Class, IIngredientType> ingredientTypeMap;
    private final NonNullList<ItemStack> fuels = NonNullList.func_191196_a();
    private final NonNullList<ItemStack> potionIngredients = NonNullList.func_191196_a();

    public IngredientRegistry(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, Map<IIngredientType, IngredientSet> ingredientsMap, ImmutableMap<IIngredientType, IIngredientHelper> ingredientHelperMap, ImmutableMap<IIngredientType, IIngredientRenderer> ingredientRendererMap) {
        this.modIdHelper = modIdHelper;
        this.blacklist = blacklist;
        this.ingredientsMap = ingredientsMap;
        this.ingredientHelperMap = ingredientHelperMap;
        this.ingredientRendererMap = ingredientRendererMap;
        ImmutableMap.Builder ingredientTypeBuilder = ImmutableMap.builder();
        for (IIngredientType ingredientType : ingredientsMap.keySet()) {
            ingredientTypeBuilder.put(ingredientType.getIngredientClass(), (Object)ingredientType);
        }
        this.ingredientTypeMap = ingredientTypeBuilder.build();
        for (ItemStack itemStack : this.getAllIngredients(VanillaTypes.ITEM)) {
            this.getStackProperties(itemStack);
        }
    }

    private void getStackProperties(ItemStack itemStack) {
        String itemStackInfo;
        try {
            if (TileEntityFurnace.func_145954_b((ItemStack)itemStack)) {
                this.fuels.add((Object)itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.get().error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
        }
        try {
            if (PotionHelper.func_185205_a((ItemStack)itemStack)) {
                this.potionIngredients.add((Object)itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.get().error("Failed to check if item is a potion ingredient {}.", (Object)itemStackInfo, (Object)e);
        }
    }

    @Override
    @Deprecated
    public <V> List<V> getIngredients(Class<V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredientClass);
        IngredientSet ingredients = this.ingredientsMap.get(ingredientType);
        if (ingredients == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)ingredients);
    }

    @Override
    public <V> Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        IngredientSet ingredients = this.ingredientsMap.get(ingredientType);
        if (ingredients == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(ingredients);
    }

    @Nullable
    public <V> V getIngredientByUid(IIngredientType<V> ingredientType, String uid) {
        IngredientSet ingredients = this.ingredientsMap.get(ingredientType);
        if (ingredients == null) {
            return null;
        }
        return ingredients.getByUid(uid);
    }

    @Override
    @Deprecated
    public <V> Collection<V> getAllIngredients(Class<V> ingredientClass) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredientClass);
        return this.getAllIngredients(ingredientType);
    }

    public <V> boolean isValidIngredient(V ingredient) {
        try {
            IIngredientHelper<V> ingredientHelper = this.getIngredientHelper(ingredient);
            return ingredientHelper.isValidIngredient(ingredient);
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientHelper(ingredientType);
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IIngredientHelper ingredientHelper = (IIngredientHelper)this.ingredientHelperMap.get(ingredientType);
        if (ingredientHelper != null) {
            return ingredientHelper;
        }
        throw new IllegalArgumentException("Unknown ingredient type: " + ingredientType);
    }

    @Override
    @Deprecated
    public <V> IIngredientHelper<V> getIngredientHelper(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType<? extends V> ingredientType = this.getIngredientType(ingredientClass);
        return this.getIngredientHelper(ingredientType);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientRenderer(ingredientType);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IIngredientRenderer ingredientRenderer = (IIngredientRenderer)this.ingredientRendererMap.get(ingredientType);
        if (ingredientRenderer == null) {
            throw new IllegalArgumentException("Could not find ingredient renderer for " + ingredientType);
        }
        return ingredientRenderer;
    }

    @Override
    @Deprecated
    public <V> IIngredientRenderer<V> getIngredientRenderer(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType<? extends V> ingredientType = this.getIngredientType(ingredientClass);
        return this.getIngredientRenderer(ingredientType);
    }

    @Override
    public Collection<IIngredientType> getRegisteredIngredientTypes() {
        return this.ingredientTypeMap.values();
    }

    @Override
    @Deprecated
    public Collection<Class> getRegisteredIngredientClasses() {
        return this.ingredientTypeMap.keySet();
    }

    @Override
    public List<ItemStack> getFuels() {
        return Collections.unmodifiableList(this.fuels);
    }

    @Override
    public List<ItemStack> getPotionIngredients() {
        return Collections.unmodifiableList(this.potionIngredients);
    }

    @Override
    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.addIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    @Override
    @Deprecated
    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredientClass);
        this.addIngredientsAtRuntime(ingredientType, ingredients);
    }

    @Override
    @Deprecated
    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredientClass);
        this.addIngredientsAtRuntime(ingredientType, ingredients);
    }

    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        Collection<EnchantmentData> enchantmentData = this.hack_getBookEnchantmentData(ingredientType, ingredients);
        if (!enchantmentData.isEmpty()) {
            this.addIngredientsAtRuntime(VanillaTypes.ENCHANT, enchantmentData, ingredientFilter);
            if (ingredients.isEmpty()) {
                return;
            }
        }
        Log.get().info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientType);
        Set set = this.ingredientsMap.computeIfAbsent(ingredientType, k -> IngredientSet.create(ingredientType, ingredientHelper));
        for (V ingredient : ingredients) {
            set.add(ingredient);
            if (!(ingredient instanceof ItemStack)) continue;
            this.getStackProperties((ItemStack)ingredient);
        }
        NonNullList<IIngredientListElement<V>> ingredientListElements = IngredientListElementFactory.createList(this, ingredientType, ingredients, this.modIdHelper);
        for (IIngredientListElement element : ingredientListElements) {
            List matchingElements = ingredientFilter.findMatchingElements(element);
            if (!matchingElements.isEmpty()) {
                for (IIngredientListElement matchingElement : matchingElements) {
                    this.blacklist.removeIngredientFromBlacklist(matchingElement.getIngredient(), ingredientHelper);
                    ingredientFilter.updateHiddenState(matchingElement);
                }
                if (!Config.isDebugModeEnabled()) continue;
                Log.get().debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(element.getIngredient()));
                continue;
            }
            this.blacklist.removeIngredientFromBlacklist(element.getIngredient(), ingredientHelper);
            ingredientFilter.addIngredient(element);
            if (!Config.isDebugModeEnabled()) continue;
            Log.get().debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(element.getIngredient()));
        }
        ingredientFilter.invalidateCache();
    }

    @Override
    @Deprecated
    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredientClass);
        this.removeIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    @Override
    @Deprecated
    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredientClass);
        this.removeIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.removeIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientType(ingredientClass);
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType ingredientType = (IIngredientType)this.ingredientTypeMap.get(ingredientClass);
        if (ingredientType != null) {
            return ingredientType;
        }
        for (IIngredientType type : this.ingredientTypeMap.values()) {
            if (!type.getIngredientClass().isAssignableFrom(ingredientClass)) continue;
            IIngredientType castType = type;
            return castType;
        }
        throw new IllegalArgumentException("Unknown ingredient class: " + ingredientClass);
    }

    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        Collection<EnchantmentData> enchantmentData = this.hack_getBookEnchantmentData(ingredientType, ingredients);
        if (!enchantmentData.isEmpty()) {
            this.removeIngredientsAtRuntime(VanillaTypes.ENCHANT, enchantmentData, ingredientFilter);
            if (ingredients.isEmpty()) {
                return;
            }
        }
        Log.get().info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        IngredientSet set = this.ingredientsMap.get(ingredientType);
        if (set != null) {
            set.removeAll(ingredients);
        }
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientType);
        NonNullList<IIngredientListElement<V>> ingredientListElements = IngredientListElementFactory.createList(this, ingredientType, ingredients, this.modIdHelper);
        for (IIngredientListElement element : ingredientListElements) {
            List matchingElements = ingredientFilter.findMatchingElements(element);
            if (matchingElements.isEmpty()) {
                Object ingredient = element.getIngredient();
                String errorInfo = ingredientHelper.getErrorInfo(ingredient);
                Log.get().error("Could not find any matching ingredients to remove: {}", (Object)errorInfo);
            } else if (Config.isDebugModeEnabled()) {
                Log.get().debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(element.getIngredient()));
            }
            for (IIngredientListElement matchingElement : matchingElements) {
                this.blacklist.addIngredientToBlacklist(matchingElement.getIngredient(), ingredientHelper);
                matchingElement.setVisible(false);
            }
        }
        ingredientFilter.invalidateCache();
    }

    public <V> boolean isIngredientVisible(V ingredient, IngredientFilter ingredientFilter) {
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        IIngredientListElement<V> element = IngredientListElementFactory.createUnorderedElement(this, ingredientType, ingredient, this.modIdHelper);
        if (element == null) {
            return false;
        }
        List<IIngredientListElement<V>> matchingElements = ingredientFilter.findMatchingElements(element);
        if (matchingElements.isEmpty()) {
            return true;
        }
        for (IIngredientListElement<V> matchingElement : matchingElements) {
            if (!matchingElement.isVisible()) continue;
            return true;
        }
        return false;
    }

    private <V> Collection<EnchantmentData> hack_getBookEnchantmentData(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        if (ingredientType == VanillaTypes.ITEM) {
            ArrayList<EnchantmentData> enchantmentData = new ArrayList<EnchantmentData>();
            Iterator<V> iterator = ingredients.iterator();
            while (iterator.hasNext()) {
                V ingredient = iterator.next();
                ItemStack itemStack = VanillaTypes.ITEM.getIngredientClass().cast(ingredient);
                EnchantmentData bookEnchantmentData = this.getBookEnchantmentData(itemStack);
                if (bookEnchantmentData == null) continue;
                enchantmentData.add(bookEnchantmentData);
                iterator.remove();
            }
            return enchantmentData;
        }
        return Collections.emptyList();
    }

    @Nullable
    private EnchantmentData getBookEnchantmentData(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemEnchantedBook) {
            NBTTagList enchantments = ItemEnchantedBook.func_92110_g((ItemStack)itemStack);
            return this.getBookEnchantmentData(enchantments);
        }
        return null;
    }

    @Nullable
    private EnchantmentData getBookEnchantmentData(NBTTagList enchantments) {
        EnchantmentData bookEnchantment = null;
        for (NBTBase nbt : enchantments) {
            if (!(nbt instanceof NBTTagCompound)) continue;
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbt;
            short id = nbttagcompound.func_74765_d("id");
            short level = nbttagcompound.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.func_185262_c((int)id);
            if (enchantment == null || level <= 0) continue;
            if (bookEnchantment == null) {
                bookEnchantment = new EnchantmentData(enchantment, (int)level);
                continue;
            }
            return null;
        }
        return bookEnchantment;
    }
}

