/*
 * Decompiled with CFR 0.152.
 */
package jsit.campfire;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigManager {
    public static Configuration config;
    public static List<String> itemBlacklist;
    public static List<String> itemWhitelist;
    public static boolean defaultBehavior;
    public static boolean enableWhitelist;
    public static boolean enableBlacklist;
    public static int burnoutTime;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigManager.load();
        }
    }

    public static void load() {
        String[] whiteList;
        String[] blackList;
        config.addCustomCategoryComment("config", "General Settings.");
        burnoutTime = config.getInt("burnout_time", "config", 7000, -1, Integer.MAX_VALUE, "Number of ticks it takes for the campfire to burnout.  If set to -1, the campfires won't burn out.  The default is 7000, or just under 6 minutes which is enough to cook just over a stack of 64.");
        defaultBehavior = config.getBoolean("default_behavior", "config", true, "Enables default behavior.  The campfire will accept any item with a smelting recipe that results in an item that extends the ItemFood class");
        enableWhitelist = config.getBoolean("enable_whitelist", "config", false, "The whitelist allows other items to be added to the campfire.  For example you can add ores or logs or food items from other mods that don't extend the ItemFood class for whatever reason.  Adding something that can't be smelted will still allow it to be added to the camp fire and the stack will burn up at the normal rate but it won't produce any results.  Enabling the whitelist and disabling the default behavior will make it so only whitelisted items can be added to the campfire.");
        enableBlacklist = config.getBoolean("enable_blacklist", "config", false, "The blacklist allows for items to be excluded from the default behavior.  If a mod adds a food that can be smelted in a furnace but it wouldn't make sense to cook it on a campfire, you could add it to the blacklist.");
        config.addCustomCategoryComment("lists", "The blacklist and whitelist.  The item names that go here can be seen in minecraft and JEI by using advanced tooltips (F3+H).");
        for (String s : blackList = config.getStringList("blacklist", "lists", new String[]{"minecraft:obsidian"}, "If enable_blacklist is true, items that would be allowed on the campfire by default or the whitelist will be excluded.  The default is just there as an example.  There's probably no reason to really blacklist obsidian.")) {
            itemBlacklist.add(s);
        }
        for (String s : whiteList = config.getStringList("whitelist", "lists", new String[]{"minecraft:potato", "drpmedieval:meat_raw_wolf"}, "If enable_whitelist is true, items listed here will be allowed on the campfire.  If you add items to this list that don't have a smelting recipe (like beds or obsidian), the campfire will still accept them and still burn through them but won't produce any results.")) {
            itemWhitelist.add(s);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("campfire")) {
            ConfigManager.load();
        }
    }

    static {
        itemBlacklist = new ArrayList<String>();
        itemWhitelist = new ArrayList<String>();
    }
}

