/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.iceandfire.client.model.animator.IceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.EnumDragonAnimations;
import com.github.alexthe666.iceandfire.client.model.util.IIceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FireDragonTabulaModelAnimator
extends IceAndFireTabulaModelAnimator
implements IIceAndFireTabulaModelAnimator<EntityFireDragon> {
    public FireDragonTabulaModelAnimator() {
        super(EnumDragonAnimations.GROUND_POSE.firedragon_model);
    }

    @Override
    public void setRotationAngles(IceAndFireTabulaModel model, EntityFireDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.resetToDefaultPose();
        model.llibAnimator.update((IAnimatedEntity)entity);
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        IceAndFireTabulaModel[] walkPoses = new IceAndFireTabulaModel[]{EnumDragonAnimations.WALK1.firedragon_model, EnumDragonAnimations.WALK2.firedragon_model, EnumDragonAnimations.WALK3.firedragon_model, EnumDragonAnimations.WALK4.firedragon_model};
        IceAndFireTabulaModel[] flyPoses = new IceAndFireTabulaModel[]{EnumDragonAnimations.FLIGHT1.firedragon_model, EnumDragonAnimations.FLIGHT2.firedragon_model, EnumDragonAnimations.FLIGHT3.firedragon_model, EnumDragonAnimations.FLIGHT4.firedragon_model, EnumDragonAnimations.FLIGHT5.firedragon_model, EnumDragonAnimations.FLIGHT6.firedragon_model};
        boolean walking = !entity.isFlying() && !entity.isHovering() && (entity.hoverProgress <= 0.0f || entity.flyProgress <= 0.0f);
        int currentIndex = walking ? entity.walkCycle / 10 : entity.flightCycle / 10;
        int prevIndex = currentIndex - 1;
        if (prevIndex < 0) {
            prevIndex = walking ? 3 : 5;
        }
        IceAndFireTabulaModel prevPosition = walking ? walkPoses[prevIndex] : flyPoses[prevIndex];
        IceAndFireTabulaModel currentPosition = walking ? walkPoses[currentIndex] : flyPoses[currentIndex];
        float delta = (float)(walking ? entity.walkCycle : entity.flightCycle) / 10.0f % 1.0f + LLibrary.PROXY.getPartialTicks() / 10.0f;
        AdvancedModelRenderer[] neckParts = new AdvancedModelRenderer[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Neck3"), model.getCube("Head")};
        AdvancedModelRenderer[] tailParts = new AdvancedModelRenderer[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        AdvancedModelRenderer[] tailPartsWBody = new AdvancedModelRenderer[]{model.getCube("BodyLower"), model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        AdvancedModelRenderer[] toesPartsL = new AdvancedModelRenderer[]{model.getCube("ToeL1"), model.getCube("ToeL2"), model.getCube("ToeL3")};
        AdvancedModelRenderer[] toesPartsR = new AdvancedModelRenderer[]{model.getCube("ToeR1"), model.getCube("ToeR2"), model.getCube("ToeR3")};
        for (AdvancedModelRenderer cube : model.getCubes().values()) {
            if (walking && entity.flyProgress <= 0.0f && entity.hoverProgress <= 0.0f && entity.hoverProgress <= 0.0f && entity.modelDeadProgress <= 0.0f) {
                float prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
                float prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
                float prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
                float x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
                float y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
                float z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
                this.addToRotateAngle(cube, limbSwingAmount, prevX + delta * this.distance(prevX, x), prevY + delta * this.distance(prevY, y), prevZ + delta * this.distance(prevZ, z));
            }
            if (entity.modelDeadProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.DEAD.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.DEAD.firedragon_model.getCube(cube.field_78802_n), entity.modelDeadProgress, 20.0f, cube.field_78802_n.equals("ThighR") || cube.field_78802_n.equals("ThighL"));
            }
            if (entity.sleepProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.SLEEPING_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SLEEPING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.sleepProgress, 20.0f, false);
            }
            if (entity.hoverProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.HOVERING_POSE.firedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube)) {
                this.transitionTo(cube, EnumDragonAnimations.HOVERING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.hoverProgress, 20.0f, false);
            }
            if (entity.flyProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.FLYING_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.FLYING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.flyProgress, 20.0f, false);
            }
            if (entity.sitProgress > 0.0f && !entity.func_184218_aH() && !this.isPartEqual(cube, EnumDragonAnimations.SITTING_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SITTING_POSE.firedragon_model.getCube(cube.field_78802_n), entity.sitProgress, 20.0f, false);
            }
            if (entity.ridingProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.firedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.firedragon_model.getCube(cube.field_78802_n), entity.ridingProgress, 20.0f, false);
                if (cube.field_78802_n.equals("BodyUpper")) {
                    cube.field_78798_e = (float)((double)cube.field_78798_e - (Math.toRadians(-15.0) - (double)cube.field_78798_e) / 20.0 * (double)entity.ridingProgress);
                }
            }
            if (entity.tackleProgress > 0.0f && !this.isPartEqual(EnumDragonAnimations.TACKLE.firedragon_model.getCube(cube.field_78802_n), EnumDragonAnimations.FLYING_POSE.firedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube)) {
                this.transitionTo(cube, EnumDragonAnimations.TACKLE.firedragon_model.getCube(cube.field_78802_n), entity.tackleProgress, 5.0f, false);
            }
            if (entity.fireBreathProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.STREAM_BREATH.firedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube) && !cube.field_78802_n.contains("Finger")) {
                this.transitionTo(cube, EnumDragonAnimations.STREAM_BREATH.firedragon_model.getCube(cube.field_78802_n), entity.fireBreathProgress, 5.0f, false);
            }
            if (walking) continue;
            AdvancedModelRenderer flightPart = EnumDragonAnimations.FLYING_POSE.firedragon_model.getCube(cube.field_78802_n);
            float prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
            float prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
            float prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
            float x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
            float y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
            float z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
            if (x == flightPart.field_78795_f && y == flightPart.field_78796_g && z == flightPart.field_78808_h) continue;
            this.setRotateAngle(cube, prevX + delta * this.distance(prevX, x), prevY + delta * this.distance(prevY, y), prevZ + delta * this.distance(prevZ, z));
        }
        float speed_walk = 0.2f;
        float speed_idle = 0.05f;
        float speed_fly = 0.2f;
        float degree_walk = 0.5f;
        float degree_idle = 0.5f;
        float degree_fly = 0.5f;
        if (!entity.func_175446_cd()) {
            if (!walking) {
                model.bob(model.getCube("BodyUpper"), -speed_fly, degree_fly * 5.0f, false, entity.field_70173_aa, 1.0f);
                model.walk(model.getCube("BodyUpper"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, entity.field_70173_aa, 1.0f);
                model.chainWave(tailPartsWBody, speed_fly, degree_fly * -0.1f, 0.0, entity.field_70173_aa, 1.0f);
                model.chainWave(neckParts, speed_fly, degree_fly * 0.2f, -4.0, entity.field_70173_aa, 1.0f);
                model.chainWave(toesPartsL, speed_fly, degree_fly * 0.2f, -2.0, entity.field_70173_aa, 1.0f);
                model.chainWave(toesPartsR, speed_fly, degree_fly * 0.2f, -2.0, entity.field_70173_aa, 1.0f);
                model.walk(model.getCube("ThighR"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, entity.field_70173_aa, 1.0f);
                model.walk(model.getCube("ThighL"), -speed_fly, degree_fly * 0.1f, true, 0.0f, 0.0f, entity.field_70173_aa, 1.0f);
            } else {
                model.bob(model.getCube("BodyUpper"), speed_walk * 2.0f, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighR"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighL"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.chainSwing(tailParts, speed_walk, degree_walk * 0.25f, -2.0, limbSwing, limbSwingAmount);
                model.chainWave(tailParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainSwing(neckParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainWave(neckParts, speed_walk, degree_walk * 0.05f, -2.0, limbSwing, limbSwingAmount);
                model.chainSwing(tailParts, speed_idle, degree_idle * 0.25f, -2.0, entity.field_70173_aa, 1.0f);
                model.chainWave(tailParts, speed_idle, degree_idle * 0.15f, -2.0, entity.field_70173_aa, 1.0f);
                model.chainWave(neckParts, speed_idle, degree_idle * -0.15f, -3.0, entity.field_70173_aa, 1.0f);
                model.walk(model.getCube("Neck1"), speed_idle, degree_idle * 0.05f, false, 0.0f, 0.0f, entity.field_70173_aa, 1.0f);
            }
            model.bob(model.getCube("BodyUpper"), speed_idle, degree_idle * 1.3f, false, entity.field_70173_aa, 1.0f);
            model.bob(model.getCube("ThighR"), speed_idle, -degree_idle * 1.3f, false, entity.field_70173_aa, 1.0f);
            model.bob(model.getCube("ThighL"), speed_idle, -degree_idle * 1.3f, false, entity.field_70173_aa, 1.0f);
            model.bob(model.getCube("ArmR1"), speed_idle, -degree_idle * 1.3f, false, entity.field_70173_aa, 1.0f);
            model.bob(model.getCube("ArmL1"), speed_idle, -degree_idle * 1.3f, false, entity.field_70173_aa, 1.0f);
            if (entity.getAnimation() != EntityDragonBase.ANIMATION_SHAKEPREY || entity.getAnimation() != EntityDragonBase.ANIMATION_ROAR) {
                model.faceTarget(rotationYaw, rotationPitch, 4.0f, neckParts);
            }
        }
        if (!entity.isModelDead()) {
            entity.turn_buffer.applyChainSwingBuffer((ModelRenderer[])neckParts);
            entity.tail_buffer.applyChainSwingBuffer((ModelRenderer[])tailPartsWBody);
        }
    }

    private boolean isWing(IceAndFireTabulaModel model, AdvancedModelRenderer modelRenderer) {
        return model.getCube((String)"ArmL1").field_78805_m.contains(modelRenderer) || model.getCube((String)"ArmR1").field_78805_m.contains(modelRenderer);
    }

    public void animate(IceAndFireTabulaModel model, EntityFireDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_SPEAK);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.setStaticKeyframe(5);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_BITE);
        model.llibAnimator.startKeyframe(15);
        this.rotate(model.llibAnimator, model.getCube("Neck1"), -12.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck2"), -5.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck3"), 5.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Head"), 36.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 20.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.rotate(model.llibAnimator, model.getCube("Neck1"), -2.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck2"), 10.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Neck3"), 10.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Head"), 20.0f, 0.0f, 0.0f);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 20.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_SHAKEPREY);
        model.llibAnimator.startKeyframe(15);
        this.moveToPose(model, EnumDragonAnimations.GRAB1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB4.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_TAILWHACK);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_FIRECHARGE);
        model.llibAnimator.startKeyframe(15);
        this.moveToPose(model, EnumDragonAnimations.STREAM_CHARGE.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_WINGBLAST);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityFireDragon.ANIMATION_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR1.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR2.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR3.firedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
    }
}

