/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.IDeadMob;
import com.github.alexthe666.iceandfire.entity.MyrmexHive;
import com.github.alexthe666.iceandfire.structures.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityMyrmexEgg
extends EntityLiving
implements IBlacklistedFromStatues,
IDeadMob {
    private static final DataParameter<Boolean> MYRMEX_TYPE = EntityDataManager.func_187226_a(EntityMyrmexEgg.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MYRMEX_AGE = EntityDataManager.func_187226_a(EntityMyrmexEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MYRMEX_CASTE = EntityDataManager.func_187226_a(EntityMyrmexEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    public UUID hiveUUID;

    public EntityMyrmexEgg(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_70105_a(0.45f, 0.55f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("Jungle", this.isJungle());
        tag.func_74768_a("MyrmexAge", this.getMyrmexAge());
        tag.func_74768_a("MyrmexCaste", this.getMyrmexCaste());
        tag.func_186854_a("HiveUUID", this.hiveUUID == null ? (this.hiveUUID = UUID.randomUUID()) : this.hiveUUID);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setJungle(tag.func_74767_n("Jungle"));
        this.setMyrmexAge(tag.func_74762_e("MyrmexAge"));
        this.setMyrmexCaste(tag.func_74762_e("MyrmexCaste"));
        this.hiveUUID = tag.func_186857_a("hiveUUID");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MYRMEX_TYPE, (Object)false);
        this.func_184212_Q().func_187214_a(MYRMEX_AGE, (Object)0);
        this.func_184212_Q().func_187214_a(MYRMEX_CASTE, (Object)0);
    }

    public boolean isJungle() {
        return (Boolean)this.func_184212_Q().func_187225_a(MYRMEX_TYPE);
    }

    public void setJungle(boolean jungle) {
        this.func_184212_Q().func_187227_b(MYRMEX_TYPE, (Object)jungle);
    }

    public int getMyrmexAge() {
        return (Integer)this.func_184212_Q().func_187225_a(MYRMEX_AGE);
    }

    public void setMyrmexAge(int i) {
        this.func_184212_Q().func_187227_b(MYRMEX_AGE, (Object)i);
    }

    public int getMyrmexCaste() {
        return (Integer)this.func_184212_Q().func_187225_a(MYRMEX_CASTE);
    }

    public void setMyrmexCaste(int i) {
        this.func_184212_Q().func_187227_b(MYRMEX_CASTE, (Object)i);
    }

    public boolean canSeeSky() {
        return this.field_70170_p.func_175710_j(new BlockPos((Entity)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.canSeeSky()) {
            this.setMyrmexAge(this.getMyrmexAge() + 1);
        }
        if (this.getMyrmexAge() > IceAndFire.CONFIG.myrmexEggTicks) {
            EntityMyrmexBase myrmex;
            this.func_70106_y();
            switch (this.getMyrmexCaste()) {
                default: {
                    myrmex = new EntityMyrmexWorker(this.field_70170_p);
                    break;
                }
                case 1: {
                    myrmex = new EntityMyrmexSoldier(this.field_70170_p);
                    break;
                }
                case 2: {
                    myrmex = new EntityMyrmexRoyal(this.field_70170_p);
                    break;
                }
                case 3: {
                    myrmex = new EntityMyrmexSentinel(this.field_70170_p);
                    break;
                }
                case 4: {
                    myrmex = new EntityMyrmexQueen(this.field_70170_p);
                }
            }
            myrmex.setJungleVariant(this.isJungle());
            myrmex.setGrowthStage(0);
            myrmex.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            if (myrmex instanceof EntityMyrmexQueen) {
                MyrmexHive hive = new MyrmexHive(this.field_70170_p, this.func_180425_c(), 100);
                EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 30.0);
                if (player != null) {
                    hive.hasOwner = true;
                    hive.ownerUUID = player.func_110124_au();
                    if (!this.field_70170_p.field_72995_K) {
                        hive.modifyPlayerReputation(player.func_110124_au(), 100);
                    }
                }
                MyrmexWorldData.addHive(this.field_70170_p, hive);
                myrmex.setHive(hive);
            } else {
                MyrmexHive hive = MyrmexWorldData.get(this.field_70170_p).getHiveFromUUID(this.hiveUUID);
                if (!this.field_70170_p.field_72995_K && hive != null && this.func_174818_b(hive.getCenter()) < 2000.0) {
                    myrmex.setHive(hive);
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)myrmex);
            }
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, ModSounds.DRAGON_HATCH, this.func_184176_by(), 2.5f, 1.0f, false);
        }
    }

    public boolean func_175446_cd() {
        return false;
    }

    public SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return null;
    }

    public boolean func_70097_a(DamageSource dmg, float var2) {
        if (dmg == DamageSource.field_76368_d) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !dmg.func_76357_e()) {
            this.func_70099_a(this.getItem(), 0.0f);
        }
        this.func_70106_y();
        return super.func_70097_a(dmg, var2);
    }

    private ItemStack getItem() {
        return new ItemStack(this.isJungle() ? ModItems.myrmex_jungle_egg : ModItems.myrmex_desert_egg, 1, this.getMyrmexCaste());
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(EntityPlayer player) {
    }

    @Override
    public boolean isMobDead() {
        return true;
    }

    public boolean isInNursery() {
        MyrmexHive hive = MyrmexWorldData.get(this.field_70170_p).getNearestHive(new BlockPos((Entity)this), 100);
        if (hive != null && hive.getRooms(WorldGenMyrmexHive.RoomType.NURSERY).isEmpty() && hive.getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_180425_c()) != null) {
            return false;
        }
        if (hive != null) {
            BlockPos nursery = hive.getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_180425_c());
            return this.func_174831_c(nursery) < 45.0;
        }
        return false;
    }
}

