/*
 * Decompiled with CFR 0.152.
 */
package dttraverse;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dttraverse.trees.SpeciesAutumnBrown;
import dttraverse.trees.SpeciesAutumnOrange;
import dttraverse.trees.SpeciesAutumnRed;
import dttraverse.trees.SpeciesAutumnYellow;
import dttraverse.trees.TreeFir;
import dttraverse.worldgen.BiomeDataBasePopulator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import prospector.traverse.init.TraverseBlocks;

@Mod.EventBusSubscriber(modid="dttraverse")
@GameRegistry.ObjectHolder(value="dttraverse")
public class ModContent {
    public static ILeavesProperties firLeavesProperties;
    public static ILeavesProperties autumnYellowLeavesProperties;
    public static ILeavesProperties autumnOrangeLeavesProperties;
    public static ILeavesProperties autumnRedLeavesProperties;
    public static ILeavesProperties autumnBrownLeavesProperties;
    public static ArrayList<TreeFamily> trees;

    @Optional.Method(modid="dynamictrees")
    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        TreeFamily oakTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak")).getFamily();
        TreeFamily birchTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "birch")).getFamily();
        Block firLeaves = (Block)TraverseBlocks.blocks.get("fir_leaves");
        ItemBlock firLeavesItem = new ItemBlock(firLeaves);
        firLeavesItem.setRegistryName(firLeaves.getRegistryName());
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)firLeavesItem);
        firLeavesProperties = new LeavesProperties(firLeaves.func_176223_P(), new ItemStack((Item)firLeavesItem, 1, 0), TreeRegistry.findCellKit((String)"conifer")){

            public int getSmotherLeavesMax() {
                return 5;
            }

            public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
                return 0xFFFFFF;
            }
        };
        Block autumnYellowLeaves = (Block)TraverseBlocks.blocks.get("yellow_autumnal_leaves");
        ItemBlock autumnYellowLeavesItem = new ItemBlock(autumnYellowLeaves);
        autumnYellowLeavesItem.setRegistryName(autumnYellowLeaves.getRegistryName());
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)autumnYellowLeavesItem);
        autumnYellowLeavesProperties = new LeavesProperties(autumnYellowLeaves.func_176223_P(), new ItemStack((Item)autumnYellowLeavesItem, 1), TreeRegistry.findCellKit((String)"deciduous")){

            public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
                return 0xFFFFFF;
            }
        };
        Block autumnOrangeLeaves = (Block)TraverseBlocks.blocks.get("orange_autumnal_leaves");
        ItemBlock autumnOrangeLeavesItem = new ItemBlock(autumnOrangeLeaves);
        autumnOrangeLeavesItem.setRegistryName(autumnOrangeLeaves.getRegistryName());
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)autumnOrangeLeavesItem);
        autumnOrangeLeavesProperties = new LeavesProperties(autumnOrangeLeaves.func_176223_P(), new ItemStack((Item)autumnOrangeLeavesItem, 1), TreeRegistry.findCellKit((String)"deciduous")){

            public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
                return 0xFFFFFF;
            }
        };
        Block autumnRedLeaves = (Block)TraverseBlocks.blocks.get("red_autumnal_leaves");
        ItemBlock autumnRedLeavesLeavesItem = new ItemBlock(autumnRedLeaves);
        autumnRedLeavesLeavesItem.setRegistryName(autumnRedLeaves.getRegistryName());
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)autumnRedLeavesLeavesItem);
        autumnRedLeavesProperties = new LeavesProperties(autumnRedLeaves.func_176223_P(), new ItemStack((Item)autumnRedLeavesLeavesItem, 1), TreeRegistry.findCellKit((String)"deciduous")){

            public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
                return 0xFFFFFF;
            }
        };
        Block autumnBrownLeaves = (Block)TraverseBlocks.blocks.get("brown_autumnal_leaves");
        ItemBlock autumnBrownLeavesLeavesItem = new ItemBlock(autumnBrownLeaves);
        autumnBrownLeavesLeavesItem.setRegistryName(autumnBrownLeaves.getRegistryName());
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)autumnBrownLeavesLeavesItem);
        autumnBrownLeavesProperties = new LeavesProperties(autumnBrownLeaves.func_176223_P(), new ItemStack((Item)autumnBrownLeavesLeavesItem, 1), TreeRegistry.findCellKit((String)"deciduous")){

            public int getSmotherLeavesMax() {
                return 1;
            }

            public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
                return 0xFFFFFF;
            }
        };
        TreeHelper.getLeavesBlockForSequence((String)"dttraverse", (int)0, (ILeavesProperties)firLeavesProperties);
        TreeHelper.getLeavesBlockForSequence((String)"dttraverse", (int)4, (ILeavesProperties)autumnYellowLeavesProperties);
        TreeHelper.getLeavesBlockForSequence((String)"dttraverse", (int)8, (ILeavesProperties)autumnOrangeLeavesProperties);
        TreeHelper.getLeavesBlockForSequence((String)"dttraverse", (int)12, (ILeavesProperties)autumnRedLeavesProperties);
        TreeHelper.getLeavesBlockForSequence((String)"dttraverse", (int)16, (ILeavesProperties)autumnBrownLeavesProperties);
        Species.REGISTRY.register((IForgeRegistryEntry)new SpeciesAutumnYellow(birchTree));
        Species.REGISTRY.register((IForgeRegistryEntry)new SpeciesAutumnOrange(oakTree));
        Species.REGISTRY.register((IForgeRegistryEntry)new SpeciesAutumnRed(oakTree));
        Species.REGISTRY.register((IForgeRegistryEntry)new SpeciesAutumnBrown(oakTree));
        TreeFir firTree = new TreeFir();
        Collections.addAll(trees, new TreeFamily[]{firTree});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(TreeHelper.getLeavesMapForModId((String)"dttraverse").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[]{TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_yellow")).getSeed(), TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_orange")).getSeed(), TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_red")).getSeed(), TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_brown")).getSeed()});
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContent.setupRecipes("fir", "fir_sapling");
        ModContent.setupRecipes("autumn_yellow", "yellow_autumnal_sapling");
        ModContent.setupRecipes("autumn_orange", "orange_autumnal_sapling");
        ModContent.setupRecipes("autumn_red", "red_autumnal_sapling");
        ModContent.setupRecipes("autumn_red", "red_brown_sapling");
    }

    public static void setupRecipes(String species, String sapling) {
        Species specie = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", species));
        ItemStack seed = specie.getSeedStack(1);
        ItemStack transofrmationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), specie.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)seed, (ItemStack)transofrmationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack((Block)TraverseBlocks.blocks.get(sapling)), (ItemStack)seed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_yellow")).getSeed());
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_orange")).getSeed());
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_red")).getSeed());
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_brown")).getSeed());
        TreeHelper.getLeavesMapForModId((String)"dttraverse").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    static {
        trees = new ArrayList();
    }
}

