/*
 * Decompiled with CFR 0.152.
 */
package dttraverse.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBasePopulatorJson;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import prospector.traverse.world.TraverseWorld;

public class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    private Species fir;
    private Species autumn_yellow;
    private Species autumn_orange;
    private Species autumn_red;
    private Species autumn_brown;
    private Species apple;
    private Species jungle;
    private Species spruce;
    private Species birch;
    private Species oak;
    private Species acacia;
    private Species swamp;
    private Species darkoak;
    private Species cactus;
    public static final String RESOURCEPATH = "worldgen/default.json";
    private static final BiomePropertySelectors.IChanceSelector ok = (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK;
    private final BiomeDataBasePopulatorJson jsonPopulator = new BiomeDataBasePopulatorJson(new ResourceLocation("dynamictrees", "worldgen/default.json"));

    public void populate(BiomeDataBase dbase) {
        this.fir = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "fir"));
        this.autumn_brown = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_brown"));
        this.autumn_orange = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_orange"));
        this.autumn_red = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_red"));
        this.autumn_yellow = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_yellow"));
        this.apple = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oakapple"));
        this.jungle = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "jungle"));
        this.spruce = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "spruce"));
        this.birch = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "birch"));
        this.oak = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak"));
        this.acacia = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "acacia"));
        this.swamp = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oakswamp"));
        this.darkoak = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "darkoak"));
        this.cactus = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "cactus"));
        ArrayList<Biome> blackList = new ArrayList<Biome>();
        blackList.add(TraverseWorld.canyonBiome);
        blackList.add(TraverseWorld.cliffsBiome);
        blackList.add(TraverseWorld.cragCliffsBiome);
        blackList.add(TraverseWorld.desertShrublandBiome);
        blackList.add(TraverseWorld.glacierBiome);
        blackList.add(TraverseWorld.glacierSpikesBiome);
        blackList.add(TraverseWorld.miniJungleBiome);
        blackList.add(TraverseWorld.mountainousDesertBiome);
        blackList.add(TraverseWorld.redDesertBiome);
        Biome.field_185377_q.forEach(biome -> {
            if (biome.getRegistryName().func_110624_b().equals("traverse") && !blackList.contains(biome)) {
                dbase.setCancelVanillaTreeGen(biome, true);
            }
        });
        this.addSpeciesSelector(dbase, TraverseWorld.autumnalWoodsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.autumn_yellow, 4).add(this.autumn_orange, 5).add(this.oak, 1).add(this.autumn_brown, 2).add(this.autumn_red, 4));
        this.addDensitySelector(dbase, TraverseWorld.autumnalWoodsBiome, this.scale(0.9));
        dbase.setChanceSelector(TraverseWorld.autumnalWoodsBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.autumnalWoodedHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.autumn_yellow, 4).add(this.autumn_orange, 5).add(this.oak, 1).add(this.autumn_brown, 2).add(this.autumn_red, 4));
        this.addDensitySelector(dbase, TraverseWorld.autumnalWoodedHillsBiome, this.scale(0.9));
        dbase.setChanceSelector(TraverseWorld.autumnalWoodedHillsBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.temperateRainforestBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(this.fir));
        dbase.setChanceSelector(TraverseWorld.temperateRainforestBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.snowyConiferousForestBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(this.fir));
        dbase.setChanceSelector(TraverseWorld.snowyConiferousForestBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.aridHighlandBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.acacia, 4).add(this.oak, 1).add(this.cactus, 1));
        this.addDensitySelector(dbase, TraverseWorld.aridHighlandBiome, this.scale(0.1));
        dbase.setChanceSelector(TraverseWorld.aridHighlandBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.badlandsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.autumn_brown, 1).add(this.oak, 1));
        this.addDensitySelector(dbase, TraverseWorld.badlandsBiome, this.scale(0.03));
        dbase.setChanceSelector(TraverseWorld.badlandsBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.birchForestedHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(this.birch));
        dbase.setChanceSelector(TraverseWorld.birchForestedHillsBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.forestedHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.oak, 4).add(this.birch, 2));
        this.addDensitySelector(dbase, TraverseWorld.forestedHillsBiome, this.scale(0.9));
        dbase.setChanceSelector(TraverseWorld.forestedHillsBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.lushHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.oak, 4).add(this.swamp, 1));
        this.addDensitySelector(dbase, TraverseWorld.lushHillsBiome, this.scale(0.4));
        dbase.setChanceSelector(TraverseWorld.lushHillsBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.lushSwampBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.swamp, 4).add(this.oak, 1));
        this.addDensitySelector(dbase, TraverseWorld.lushSwampBiome, this.scale(0.6));
        dbase.setChanceSelector(TraverseWorld.lushSwampBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.meadowBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.oak, 2).add(this.birch, 1));
        this.addDensitySelector(dbase, TraverseWorld.meadowBiome, this.scale(0.01));
        dbase.setChanceSelector(TraverseWorld.meadowBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.rockyPlainsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.oak, 2));
        this.addDensitySelector(dbase, TraverseWorld.rockyPlainsBiome, this.scale(0.01));
        dbase.setChanceSelector(TraverseWorld.rockyPlainsBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.rockyPlateauBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.oak, 2));
        this.addDensitySelector(dbase, TraverseWorld.rockyPlateauBiome, this.scale(0.01));
        dbase.setChanceSelector(TraverseWorld.rockyPlateauBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.thicketBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(this.oak, 4).add(this.darkoak, 2));
        this.addDensitySelector(dbase, TraverseWorld.thicketBiome, this.scale(1.5));
        dbase.setChanceSelector(TraverseWorld.thicketBiome, ok, BiomeDataBase.Operation.REPLACE);
        this.addSpeciesSelector(dbase, TraverseWorld.woodlandsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(this.oak));
        this.addDensitySelector(dbase, TraverseWorld.woodlandsBiome, this.scale(0.6));
        dbase.setChanceSelector(TraverseWorld.woodlandsBiome, ok, BiomeDataBase.Operation.REPLACE);
    }

    private void addSpeciesSelector(BiomeDataBase dbase, Biome biome, BiomePropertySelectors.ISpeciesSelector selector) {
        dbase.setSpeciesSelector(biome, selector, BiomeDataBase.Operation.REPLACE);
    }

    private BiomePropertySelectors.IChanceSelector rand(float threshhold) {
        return (rnd, spc, rad) -> rnd.nextFloat() < threshhold ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL;
    }

    private void addDensitySelector(BiomeDataBase dbase, Biome biome, BiomePropertySelectors.IDensitySelector selector) {
        dbase.setDensitySelector(biome, selector, BiomeDataBase.Operation.REPLACE);
    }

    private BiomePropertySelectors.IDensitySelector scale() {
        return (rnd, nd) -> nd;
    }

    private BiomePropertySelectors.IDensitySelector scale(double factor1) {
        return (rnd, nd) -> nd * factor1;
    }

    private BiomePropertySelectors.IDensitySelector scale(double factor1, double addend) {
        return (rnd, nd) -> nd * factor1 + addend;
    }

    private BiomePropertySelectors.IDensitySelector scale(double factor1, double addend, double factor2) {
        return (rnd, nd) -> (nd * factor1 + addend) * factor2;
    }
}

