/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.snow.EntityFallingSnow;
import snownee.snow.ModConfig;
import snownee.snow.TileSnowLayer;

public class BlockSnowLayer
extends BlockSnow {
    protected static final AxisAlignedBB[] SNOW_AABB_MAGIC = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)};
    public static final PropertyBool TILE = PropertyBool.func_177716_a((String)"tile");

    public BlockSnowLayer() {
        if (ModConfig.placeSnowInBlock) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(false)));
        }
        this.setRegistryName("minecraft", "snow_layer");
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185856_i);
        this.func_149663_c("snow");
        this.func_149713_g(0);
    }

    protected BlockStateContainer func_180661_e() {
        if (ModConfig.placeSnowInBlock) {
            return new BlockStateContainer((Block)this, new IProperty[]{field_176315_a, TILE});
        }
        return super.func_180661_e();
    }

    public boolean hasTileEntity(IBlockState state) {
        if (ModConfig.placeSnowInBlock) {
            return (Boolean)state.func_177229_b((IProperty)TILE);
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (ModConfig.placeSnowInBlock) {
            return new TileSnowLayer();
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        if (ModConfig.placeSnowInBlock) {
            IBlockState state = super.func_176203_a(meta);
            if (meta >= 8) {
                state = state.func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return super.func_176203_a(meta);
    }

    public int func_176201_c(IBlockState state) {
        int meta = super.func_176201_c(state);
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (!ModConfig.thinnerBoundingBox) {
            return super.func_180646_a(blockState, worldIn, pos);
        }
        int layers = (Integer)blockState.func_177229_b((IProperty)field_176315_a);
        if (layers == 8 && !worldIn.func_175623_d(pos.func_177984_a())) {
            return field_185505_j;
        }
        return SNOW_AABB_MAGIC[layers - 1];
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (ModConfig.snowGravity) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (ModConfig.snowGravity) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.checkFallable(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        if (ModConfig.snowOnIce || block != Blocks.field_150432_aD && block != Blocks.field_150403_cj && block != Blocks.field_180401_cv) {
            BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
            return blockfaceshape == BlockFaceShape.SOLID || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b()) || block == this && (Integer)iblockstate.func_177229_b((IProperty)field_176315_a) == 8;
        }
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (!ModConfig.snowNeverMelt && worldIn.func_175642_b(EnumSkyBlock.BLOCK, pos) > 11) {
            worldIn.func_175698_g(pos);
            return;
        }
        if (!ModConfig.snowAccumulationDuringSnowfall && !ModConfig.snowAccumulationDuringSnowstorm) {
            return;
        }
        if (random.nextInt(8) > 0 || !worldIn.func_175678_i(pos.func_177984_a())) {
            return;
        }
        int layers = (Integer)state.func_177229_b((IProperty)field_176315_a);
        boolean flag = false;
        if (worldIn.func_72896_J()) {
            if (ModConfig.snowAccumulationDuringSnowfall) {
                flag = true;
            } else if (ModConfig.snowAccumulationDuringSnowstorm && worldIn.func_72911_I()) {
                flag = true;
            }
        }
        if (worldIn.func_175708_f(pos, false)) {
            if (flag && layers < 8) {
                if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && worldIn.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(layers + 1)));
                }
            } else if (layers > 1 && !worldIn.func_72896_J() && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(layers - 1)));
            }
        }
    }

    private boolean checkFallable(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos posDown = pos.func_177977_b();
        if ((worldIn.func_175623_d(posDown) || BlockSnowLayer.canFallThrough(worldIn.func_180495_p(posDown), worldIn, posDown)) && pos.func_177956_o() >= 0) {
            int i = 32;
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175698_g(pos);
                    EntityFallingSnow entityfallingblock = new EntityFallingSnow(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (Integer)state.func_177229_b((IProperty)field_176315_a));
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockSnowLayer.canFallThrough(worldIn.func_180495_p(blockpos), worldIn, blockpos)) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
            return true;
        }
        return false;
    }

    public static void placeLayersOn(World world, BlockPos pos, int layers, boolean falling) {
        IBlockState base;
        layers = MathHelper.func_76125_a((int)layers, (int)1, (int)8);
        IBlockState state = world.func_180495_p(pos);
        int originLayers = 0;
        boolean flag = false;
        if (state.func_177230_c() == Blocks.field_150431_aC) {
            originLayers = (Integer)state.func_177229_b((IProperty)field_176315_a);
            base = state;
        } else {
            base = Blocks.field_150431_aC.func_176223_P();
            if (BlockSnowLayer.canContainState(state)) {
                flag = true;
                base = base.func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(true));
            }
        }
        if (flag || state.func_177230_c() == Blocks.field_150431_aC || state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            TileEntity tile;
            world.func_175656_a(pos, base.func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(originLayers + layers), (int)1, (int)8))));
            if (flag && (tile = world.func_175625_s(pos)) instanceof TileSnowLayer) {
                ((TileSnowLayer)tile).setState(state);
            }
            if (falling) {
                world.func_175641_c(pos, Blocks.field_150431_aC, originLayers, layers);
            } else {
                SoundType soundtype = Blocks.field_150431_aC.getSoundType(state, world, pos, null);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
            if (originLayers + layers > 8 && world.func_180495_p(pos = pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(originLayers + layers - 8), (int)1, (int)8))));
            }
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int originLayers, int layers) {
        double offsetY = (double)originLayers / 8.0;
        layers *= 10;
        for (int i = 0; i < layers; ++i) {
            double d0 = RANDOM.nextGaussian() * 0.2;
            double d1 = RANDOM.nextGaussian() * 0.02;
            double d2 = RANDOM.nextGaussian() * 0.2;
            worldIn.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, (double)((float)pos.func_177958_n() + RANDOM.nextFloat()), (double)pos.func_177956_o() + offsetY, (double)((float)pos.func_177952_p() + RANDOM.nextFloat()), d0, d1, d2, new int[0]);
        }
        SoundType soundtype = this.getSoundType(state, worldIn, pos, null);
        worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        return true;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            return this.getContainedState(worldIn, pos).func_185904_a().func_76222_j();
        }
        return ModConfig.snowAlwaysReplaceable && (Integer)state.func_177229_b((IProperty)field_176315_a) < 8 || super.func_176200_f(worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!ModConfig.particleThroughLeaves || rand.nextInt(31) != 1) {
            return;
        }
        IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        if (stateDown.func_177230_c().isLeaves(stateDown, (IBlockAccess)worldIn, pos.func_177977_b())) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static boolean canContainState(IBlockState state) {
        if (!ModConfig.placeSnowInBlock || state.func_177230_c().hasTileEntity(state)) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block instanceof BlockTallGrass || block instanceof BlockFlower || block instanceof BlockSapling || block instanceof BlockMushroom) {
            return true;
        }
        return block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockPane;
    }

    public IBlockState getContainedState(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSnowLayer) {
            return ((TileSnowLayer)tile).getState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            IBlockState stateIn = this.getContainedState(worldIn, pos);
            Block block = stateIn.func_177230_c();
            if (block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockPane) {
                return face == EnumFacing.UP ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
            }
            return stateIn.func_193401_d(worldIn, pos, face);
        }
        return super.func_193383_a(worldIn, state, pos, face);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getContainedState(world, pos).func_177230_c().canBeConnectedTo(world, pos, facing);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        BlockSnowLayer.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            this.getContainedState((IBlockAccess)worldIn, pos).func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos).func_185904_a() == Material.field_151579_a && this.hasTileEntity(state)) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileSnowLayer) {
                IBlockState newState = ((TileSnowLayer)tile).getState();
                worldIn.func_175713_t(pos);
                if (worldIn.func_175656_a(pos, newState)) {
                    newState.func_177230_c().func_189540_a(newState, worldIn, pos, newState.func_177230_c(), pos.func_177977_b());
                }
            } else {
                worldIn.func_175713_t(pos);
            }
        }
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        if (ModConfig.placeSnowInBlock) {
            return this.getContainedState(worldIn, pos).func_177230_c().func_176205_b(worldIn, pos);
        }
        return super.func_176205_b(worldIn, pos);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.hasTileEntity(state) ? EnumPushReaction.BLOCK : EnumPushReaction.DESTROY;
    }

    public static boolean canFallThrough(IBlockState state, World worldIn, BlockPos pos) {
        return BlockFalling.func_185759_i((IBlockState)state) && state.func_185890_d((IBlockAccess)worldIn, pos) == null;
    }
}

