/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.util;

import java.io.ByteArrayOutputStream;
import java.util.Optional;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class IvStreams {
    public static <T> boolean visit(Stream<T> source, Predicate<T> action) {
        for (Object item : source::iterator) {
            if (action.test(item)) continue;
            return false;
        }
        return true;
    }

    public static <T> Stream<T> streamopt(Optional<T> opt) {
        if (opt.isPresent()) {
            return Stream.of(opt.get());
        }
        return Stream.empty();
    }

    public static <T> Stream<T> flatMapToObj(IntStream stream, IntFunction<Stream<? extends T>> function) {
        return stream.mapToObj(function).flatMap(Function.identity());
    }

    public static <T> Stream<T> flatMapToObj(DoubleStream stream, DoubleFunction<Stream<? extends T>> function) {
        return stream.mapToObj(function).flatMap(Function.identity());
    }

    public static <T> Stream<T> flatMapToObj(LongStream stream, LongFunction<Stream<? extends T>> function) {
        return stream.mapToObj(function).flatMap(Function.identity());
    }

    public static byte[] toByteArray(IntStream stream) {
        return stream.collect(ByteArrayOutputStream::new, (baos, i) -> baos.write((byte)i), (baos1, baos2) -> baos1.write(baos2.toByteArray(), 0, baos2.size())).toByteArray();
    }
}

