/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.entity.animaltameevent;

import codersafterdark.compatskills.common.compats.minecraft.entity.animaltameevent.EntityTameKey;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.LevelLockHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AnimalTameEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTame(AnimalTameEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getTamer();
        if (Utils.skipPlayer(player)) {
            return;
        }
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        RequirementHolder requirementHolder = LevelLockHandler.getLockByKey((LockKey)new EntityTameKey((Entity)event.getAnimal()));
        if (!requirementHolder.equals(LevelLockHandler.EMPTY_LOCK) && !data.matchStats(requirementHolder)) {
            event.setCanceled(true);
            TextComponentTranslation error = new TextComponentTranslation("compatskills.error.entity.tame", new Object[0]);
            player.func_146105_b(Utils.getError(requirementHolder, data, error), false);
        }
    }
}

