/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.transmutations;

import codersafterdark.compatskills.CompatSkills;
import codersafterdark.compatskills.common.compats.reskillable.ReskillableCompatHandler;
import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.reskillable.api.transmutations.TransmutationRegistry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="reskillable")
@ZenClass(value="mods.compatskills.transmutations.removals")
@ZenRegister
public class RemovalTweakers {
    @ZenMethod
    public static void removeStartStateFromReagent(IItemStack reagent, IItemStack startState) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveStartStateFromReagent(reagent, startState));
        }
    }

    @ZenMethod
    public static void removeStartStateFromReagent(IItemStack reagent, crafttweaker.api.block.IBlockState state) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveStartStateFromReagent(reagent, state));
        }
    }

    @ZenMethod
    public static void removeStartStateReagentAgnostic(IItemStack state) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveStartStateReagentAgnostic(state));
        }
    }

    @ZenMethod
    public static void removeStartStateReagentAgnostic(crafttweaker.api.block.IBlockState state) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveStartStateReagentAgnostic(state));
        }
    }

    @ZenMethod
    public static void removeEndStateFromReagent(IItemStack reagent, IItemStack state) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveEndStateFromReagent(reagent, state));
        }
    }

    @ZenMethod
    public static void removeEndStateFromReagent(IItemStack reagent, crafttweaker.api.block.IBlockState state) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveEndStateFromReagent(reagent, state));
        }
    }

    @ZenMethod
    public static void removeEndStateReagentAgnostic(IItemStack state) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveEndStateReagentAgnostic(state));
        }
    }

    @ZenMethod
    public static void removeEndStateReagentAgnostic(crafttweaker.api.block.IBlockState state) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new RemoveEndStateReagentAgnostic(state));
        }
    }

    private static class RemoveEndStateReagentAgnostic
    implements IAction {
        private final IBlockState state;

        private RemoveEndStateReagentAgnostic(IItemStack state) {
            this.state = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state));
        }

        private RemoveEndStateReagentAgnostic(crafttweaker.api.block.IBlockState state) {
            this.state = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state);
        }

        public void apply() {
            TransmutationRegistry.removeEndStateFromReagentAgnostic((IBlockState)this.state);
        }

        public String describe() {
            return "Removing End State: " + this.state.func_177230_c().func_149732_F() + " From All Reagents!";
        }
    }

    private static class RemoveEndStateFromReagent
    implements IAction {
        private final Item reagent;
        private final IBlockState state;

        private RemoveEndStateFromReagent(IItemStack reagent, IItemStack state) {
            this.reagent = CraftTweakerMC.getItemStack((IItemStack)reagent).func_77973_b();
            this.state = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state));
        }

        private RemoveEndStateFromReagent(IItemStack reagent, crafttweaker.api.block.IBlockState state) {
            this.reagent = CraftTweakerMC.getItemStack((IItemStack)reagent).func_77973_b();
            this.state = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state);
        }

        public void apply() {
            TransmutationRegistry.removeEndStateFromReagent((Item)this.reagent, (IBlockState)this.state);
        }

        public String describe() {
            return "Removing End State: " + this.state.func_177230_c().func_149732_F() + " From Reagent: " + this.reagent.func_77653_i(new ItemStack(this.reagent));
        }
    }

    private static class RemoveStartStateReagentAgnostic
    implements IAction {
        private final IBlockState state;

        private RemoveStartStateReagentAgnostic(IItemStack state) {
            this.state = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state));
        }

        private RemoveStartStateReagentAgnostic(crafttweaker.api.block.IBlockState state) {
            this.state = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state);
        }

        public void apply() {
            TransmutationRegistry.removeStartStateFromReagentAgnostic((IBlockState)this.state);
        }

        public String describe() {
            return "Removing Start State: " + this.state.func_177230_c().func_149732_F() + " From All Reagents!";
        }
    }

    private static class RemoveStartStateFromReagent
    implements IAction {
        private final Item reagent;
        private final IBlockState state;

        private RemoveStartStateFromReagent(IItemStack reagent, IItemStack state) {
            this.reagent = CraftTweakerMC.getItemStack((IItemStack)reagent).func_77973_b();
            this.state = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state));
        }

        private RemoveStartStateFromReagent(IItemStack reagent, crafttweaker.api.block.IBlockState state) {
            this.reagent = CraftTweakerMC.getItemStack((IItemStack)reagent).func_77973_b();
            this.state = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state);
        }

        public void apply() {
            TransmutationRegistry.removeStartStateFromReagent((Item)this.reagent, (IBlockState)this.state);
        }

        public String describe() {
            return "Removing Start State: " + this.state.func_177230_c().func_149732_F() + " From Reagent: " + this.reagent.func_77653_i(new ItemStack(this.reagent));
        }
    }
}

