/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.client.gui.HudLoadState;
import com.oblivioussp.spartanweaponry.client.gui.HudQuiverAmmo;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.item.IHudLoadState;
import com.oblivioussp.spartanweaponry.item.ItemCrossbow;
import com.oblivioussp.spartanweaponry.item.ItemDagger;
import com.oblivioussp.spartanweaponry.item.ItemLongbow;
import com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.network.PacketLongReachAttack;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.LogHelper;
import com.oblivioussp.spartanweaponry.util.NBTHelper;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import com.oblivioussp.spartanweaponry.util.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class EventHandlerClient {
    protected static final ResourceLocation CROSSHAIR_TEXTURES = new ResourceLocation("spartanweaponry", "textures/gui/crosshairs.png");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onMouseEvent(MouseEvent ev) {
        KeyBinding keyAttack = Minecraft.func_71410_x().field_71474_y.field_74312_F;
        if (keyAttack.func_151463_i() < 0 && ev.getButton() == keyAttack.func_151463_i() + 100 && ev.isButtonstate()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null) {
                ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
                WeaponProperty reachProperty = null;
                if (!stack.func_190926_b()) {
                    float reach;
                    RayTraceResult result;
                    if (stack.func_77973_b() instanceof IWeaponPropertyContainer) {
                        IWeaponPropertyContainer container = (IWeaponPropertyContainer)stack.func_77973_b();
                        reachProperty = container.getFirstWeaponPropertyWithType("reach");
                    }
                    if (reachProperty != null && (result = EventHandlerClient.getMouseOverExtended(reach = reachProperty.getMagnitude())) != null && result.field_72308_g != null && result.field_72308_g.field_70172_ad == 0 && result.field_72308_g != player && result.field_72308_g != player.func_184187_bx()) {
                        NetworkHandler.sendPacketToServer(new PacketLongReachAttack(result.field_72308_g.func_145782_y()));
                    }
                }
            }
        }
    }

    protected static RayTraceResult getMouseOverExtended(float distance) {
        RayTraceResult result = null;
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderViewEntity = mc.func_175606_aa();
        if (renderViewEntity != null && mc.field_71441_e != null) {
            double d0 = distance;
            result = renderViewEntity.func_174822_a(d0, 0.0f);
            Vec3d eyePos = renderViewEntity.func_174824_e(0.0f);
            boolean flag = false;
            double d1 = d0;
            if (mc.field_71442_b.func_78749_i() && d1 < 6.0) {
                d0 = d1 = 6.0;
            } else if (d0 > (double)distance) {
                flag = true;
            }
            if (result != null) {
                d1 = result.field_72307_f.func_72438_d(eyePos);
            }
            Vec3d lookVec = renderViewEntity.func_70676_i(0.0f);
            Vec3d vec3d2 = eyePos.func_72441_c(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0);
            Entity pointedEntity = null;
            Vec3d vec3d3 = null;
            List list = mc.field_71441_e.func_175674_a(renderViewEntity, renderViewEntity.func_174813_aQ().func_72321_a(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0).func_72321_a(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.func_70067_L();
                }
            }));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult result0 = axisalignedbb.func_72327_a(eyePos, vec3d2);
                if (axisalignedbb.func_72318_a(eyePos)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = result0 == null ? eyePos : result0.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (result0 == null || !((d3 = eyePos.func_72438_d(result0.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == renderViewEntity.func_184208_bv() && !renderViewEntity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = result0.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = result0.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && flag && eyePos.func_72438_d(vec3d3) > (double)distance) {
                pointedEntity = null;
                result = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
                LogHelper.debug("Ray Trace for extended reach has missed!");
            }
            if (pointedEntity != null && (d2 < d1 || result == null)) {
                result = new RayTraceResult(pointedEntity, vec3d3);
                LogHelper.debug("Ray Trace for extended reach has hit a " + pointedEntity.toString() + " d1 = " + d1 + " - d2 = " + d2);
                if (pointedEntity instanceof EntityLivingBase || pointedEntity instanceof EntityItemFrame) {
                    // empty if block
                }
            }
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFOVUpdate(FOVUpdateEvent ev) {
        EntityPlayer player = ev.getEntity();
        ItemStack activeStack = player.func_184607_cu();
        if (activeStack.func_190926_b()) {
            return;
        }
        float currentFov = ev.getFov();
        float fovZoomIn = 0.2f;
        float newFov = currentFov;
        int ticksToZoomIn = 0;
        int currentTicks = activeStack.func_77988_m() - player.func_184605_cv();
        if (activeStack.func_77973_b() instanceof ItemLongbow) {
            ticksToZoomIn = (int)(ConfigHandler.multiplierLongbow * 20.0f);
        } else if (activeStack.func_77973_b() instanceof ItemCrossbow && NBTHelper.getBoolean(activeStack, "isLoaded")) {
            ticksToZoomIn = 10;
        } else if (activeStack.func_77973_b() instanceof ItemDagger || activeStack.func_77973_b() instanceof ItemThrowingWeapon) {
            ticksToZoomIn = 5;
            fovZoomIn = 0.1f;
        }
        if (ticksToZoomIn > 0) {
            if (currentTicks >= ticksToZoomIn) {
                currentTicks = ticksToZoomIn;
            }
            newFov = currentFov - fovZoomIn * ((float)currentTicks / (float)ticksToZoomIn);
            ev.setNewfov(newFov);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent ev) {
        ItemStack stack = ev.getItemStack();
        if (stack.func_77973_b() instanceof ItemThrowingWeapon) {
            ItemThrowingWeapon weapon = (ItemThrowingWeapon)stack.func_77973_b();
            int j = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_DAMAGE, (ItemStack)stack);
            float throwDamage = (weapon.getDirectAttackDamage() + 1.0f) * weapon.getThrownDamageMultiplier() + (float)j * 0.5f;
            ev.getToolTip().add("");
            ev.getToolTip().add(StringHelper.translateString("modifiers.thrown", "tooltip"));
            ev.getToolTip().add(" " + StringHelper.translateFormattedString("attribute.damage", "tooltip", "spartanweaponry", ItemStack.field_111284_a.format(throwDamage)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onSpecificHandRender(RenderSpecificHandEvent ev) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184600_cs() != ev.getHand()) {
            ItemStack activeStack = player.func_184607_cu();
            if (activeStack.func_77973_b() instanceof ItemLongbow) {
                ev.setCanceled(true);
            } else if (activeStack.func_77973_b() instanceof ItemCrossbow) {
                ev.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre ev) {
        if (ev.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            Minecraft mc = Minecraft.func_71410_x();
            GameSettings settings = mc.field_71474_y;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            int x = ev.getResolution().func_78326_a() / 2;
            int y = ev.getResolution().func_78328_b() / 2;
            if ((!ConfigHandler.disableNewCrosshairCrossbow || ConfigHandler.forceCompatibilityCrosshairs) && settings.field_74320_O == 0 && player.func_184614_ca().func_77973_b() instanceof ItemCrossbow) {
                ItemStack crossbow = player.func_184607_cu();
                int offset = 80 / ev.getResolution().func_78325_e();
                if (crossbow != null && NBTHelper.getBoolean(crossbow, "isLoaded")) {
                    int currentTicks = crossbow.func_77988_m() - player.func_184605_cv();
                    float percentage = MathHelper.func_76131_a((float)(((float)currentTicks + ev.getPartialTicks()) / 10.0f), (float)0.0f, (float)1.0f);
                    offset = (int)((float)offset * (1.0f - percentage));
                }
                if (settings.field_74330_P && !settings.field_74319_N && !mc.field_71439_g.func_175140_cp() && !settings.field_178879_v) {
                    return;
                }
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179084_k();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(CROSSHAIR_TEXTURES);
                if (Loader.isModLoaded((String)"bettercombatmod") || ConfigHandler.forceCompatibilityCrosshairs) {
                    offset = (int)Math.sqrt((double)(offset * offset) / 2.0);
                    mc.field_71456_v.func_73729_b(x - 5 - offset, y - 5 - offset, 11, 12, 4, 4);
                    mc.field_71456_v.func_73729_b(x + 2 + offset, y - 5 - offset, 18, 12, 4, 4);
                    mc.field_71456_v.func_73729_b(x - 5 - offset, y + 2 + offset, 11, 19, 4, 4);
                    mc.field_71456_v.func_73729_b(x + 2 + offset, y + 2 + offset, 18, 19, 4, 4);
                } else {
                    mc.field_71456_v.func_73729_b(x - 1, y - 1, 4, 4, 3, 3);
                    mc.field_71456_v.func_73729_b(x, y - 5 - offset, 5, 0, 1, 4);
                    mc.field_71456_v.func_73729_b(x, y + 2 + offset, 5, 7, 1, 4);
                    mc.field_71456_v.func_73729_b(x - 5 - offset, y, 0, 5, 4, 1);
                    mc.field_71456_v.func_73729_b(x + 2 + offset, y, 7, 5, 4, 1);
                    ev.setCanceled(true);
                }
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179084_k();
            } else if ((!ConfigHandler.disableNewCrosshairThrowingWeapon || ConfigHandler.forceCompatibilityCrosshairs) && settings.field_74320_O == 0 && player.func_184614_ca().func_77973_b() instanceof ItemThrowingWeapon) {
                int offset;
                ItemStack throwingWeapon = player.func_184614_ca();
                int n = offset = Loader.isModLoaded((String)"bettercombatmod") ? 12 : 10;
                if (player.func_184587_cr() && player.func_184600_cs() == EnumHand.MAIN_HAND) {
                    int currentTicks = throwingWeapon.func_77988_m() - player.func_184605_cv();
                    float percentage = MathHelper.func_76131_a((float)(((float)currentTicks + ev.getPartialTicks()) / 5.0f), (float)0.0f, (float)1.0f);
                    offset = (int)((float)offset * (1.0f - percentage));
                }
                if (settings.field_74330_P && !settings.field_74319_N && !mc.field_71439_g.func_175140_cp() && !settings.field_178879_v) {
                    return;
                }
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(CROSSHAIR_TEXTURES);
                if (Loader.isModLoaded((String)"bettercombatmod") || ConfigHandler.forceCompatibilityCrosshairs) {
                    offset = (int)Math.sqrt((double)(offset * offset) / 2.0);
                    mc.field_71456_v.func_73729_b(x - 5 - offset, y - 5 - offset, 11, 12, 4, 4);
                    mc.field_71456_v.func_73729_b(x + 2 + offset, y - 5 - offset, 18, 12, 4, 4);
                    mc.field_71456_v.func_73729_b(x - 5 - offset, y + 2 + offset, 11, 19, 4, 4);
                    mc.field_71456_v.func_73729_b(x + 2 + offset, y + 2 + offset, 18, 19, 4, 4);
                } else {
                    mc.field_71456_v.func_73729_b(x - 4, y - 4, 12, 1, 9, 5);
                    mc.field_71456_v.func_73729_b(x - 4, y - 7 - offset, 12, 1, 9, 5);
                    ev.setCanceled(true);
                }
                GuiIngame cfr_ignored_0 = mc.field_71456_v;
                mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
                if (mc.field_71474_y.field_186716_M == 1 && !Loader.isModLoaded((String)"bettercombatmod") && !ConfigHandler.forceCompatibilityCrosshairs) {
                    float f = player.func_184825_o(0.0f);
                    boolean flag = false;
                    if (mc.field_147125_j != null && mc.field_147125_j instanceof EntityLivingBase && f >= 1.0f) {
                        flag = mc.field_71439_g.func_184818_cX() > 5.0f;
                        flag &= ((EntityLivingBase)mc.field_147125_j).func_70089_S();
                    }
                    int i = y - 7 + 16;
                    int j = x - 8;
                    if (flag) {
                        mc.field_71456_v.func_73729_b(j, i, 68, 94, 16, 16);
                    } else if (f < 1.0f) {
                        int k = (int)(f * 17.0f);
                        mc.field_71456_v.func_73729_b(j, i, 36, 94, 16, 4);
                        mc.field_71456_v.func_73729_b(j, i, 52, 94, k, 4);
                    }
                }
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179084_k();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post ev) {
        if (ev.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack weaponStack = ItemStack.field_190927_a;
            ItemStack quiverStack = ItemStack.field_190927_a;
            for (QuiverHelper.IQuiverInfo iQuiverInfo : QuiverHelper.info) {
                if (iQuiverInfo.isWeapon(player.func_184614_ca())) {
                    weaponStack = player.func_184614_ca();
                    quiverStack = QuiverHelper.findFirstOfType((EntityPlayer)player, iQuiverInfo);
                    break;
                }
                if (!iQuiverInfo.isWeapon(player.func_184592_cb())) continue;
                weaponStack = player.func_184592_cb();
                quiverStack = QuiverHelper.findFirstOfType((EntityPlayer)player, iQuiverInfo);
                break;
            }
            String weaponName = weaponStack.func_77973_b().getRegistryName().toString();
            for (String compName : ConfigHandler.quiverBowBlacklist) {
                if (!compName.equals(weaponName)) continue;
                weaponStack = ItemStack.field_190927_a;
            }
            if (weaponStack.func_190926_b() || quiverStack.func_190926_b()) {
                HudQuiverAmmo.hudActive = null;
            }
            if (!weaponStack.func_190926_b() && !quiverStack.func_190926_b()) {
                if (HudQuiverAmmo.hudActive == null) {
                    HudQuiverAmmo.hudActive = new HudQuiverAmmo(64, 20, quiverStack);
                } else {
                    HudQuiverAmmo.hudActive.setQuiver(quiverStack);
                }
                if (HudQuiverAmmo.hudActive != null) {
                    HudQuiverAmmo.hudActive.render();
                }
            }
            int n = -1;
            ItemStack loadStack = ItemStack.field_190927_a;
            IHudLoadState loadItem = null;
            boolean isOffhand = false;
            if (player.func_184614_ca().func_77973_b() instanceof IHudLoadState) {
                loadStack = player.func_184614_ca();
                loadItem = (IHudLoadState)loadStack.func_77973_b();
            } else if (player.func_184592_cb().func_77973_b() instanceof IHudLoadState) {
                loadStack = player.func_184592_cb();
                loadItem = (IHudLoadState)loadStack.func_77973_b();
                isOffhand = true;
            }
            if (loadStack != null && loadItem != null && (!loadStack.func_190926_b() && player.func_184607_cu().func_77969_a(loadStack) || loadItem.isLoaded(loadStack))) {
                if (HudLoadState.hudActive == null) {
                    HudLoadState.hudActive = new HudLoadState();
                }
                HudLoadState.hudActive.setLoaded(loadItem.isLoaded(loadStack));
                HudLoadState.hudActive.setLoadProgress(loadItem.getLoadProgress(loadStack, (EntityLivingBase)player));
                HudLoadState.hudActive.setOffhand(isOffhand);
                if (!isOffhand) {
                    int n2;
                    int i = 0;
                    while (true) {
                        EntityPlayerSP entityPlayerSP = player;
                        if (i >= entityPlayerSP.field_71071_by.func_70451_h()) break;
                        if (player.field_71071_by.func_70301_a(i).func_77969_a(loadStack)) {
                            n2 = i;
                        }
                        ++i;
                    }
                    HudLoadState.hudActive.setHighlightedSlot(n2);
                }
                if (HudLoadState.hudActive != null) {
                    HudLoadState.hudActive.render();
                }
            } else if (HudLoadState.hudActive != null) {
                HudLoadState.hudActive = null;
            }
        }
    }
}

