/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.integration.crafttweaker;

import com.alcatrazescapee.alcatrazcore.inventory.ingredient.IRecipeIngredient;
import com.alcatrazescapee.alcatrazcore.inventory.recipe.IRecipeCore;
import com.alcatrazescapee.notreepunching.common.recipe.FirePitRecipe;
import com.alcatrazescapee.notreepunching.common.recipe.ModRecipes;
import com.alcatrazescapee.notreepunching.integration.crafttweaker.CraftTweakerPlugin;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.notreepunching.FirePit")
public class CTFirePitRecipe {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output) {
        FirePitRecipe recipe;
        ItemStack outputStack = CraftTweakerPlugin.toStack((IIngredient)output);
        if (input instanceof IOreDictEntry) {
            IOreDictEntry ore = (IOreDictEntry)input;
            recipe = new FirePitRecipe(outputStack, ore.getName(), ore.getAmount());
        } else {
            recipe = new FirePitRecipe(outputStack, CraftTweakerPlugin.toStack(input));
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ModRecipes.addScheduledAction(() -> ModRecipes.FIRE_PIT.add((IRecipeCore)recipe));
            }

            public String describe() {
                return "Adding Fire pit recipe for " + recipe.getName();
            }
        });
    }

    @ZenMethod
    public static void remove(IIngredient input) {
        IRecipeIngredient ingredient;
        if (input instanceof IOreDictEntry) {
            IOreDictEntry ore = (IOreDictEntry)input;
            ingredient = IRecipeIngredient.of((String)ore.getName(), (int)ore.getAmount());
        } else {
            ingredient = IRecipeIngredient.of((ItemStack)CraftTweakerPlugin.toStack(input));
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ModRecipes.addScheduledAction(() -> ModRecipes.FIRE_PIT.remove((Object)ingredient));
            }

            public String describe() {
                return "Removing Fire pit recipe for " + ingredient.getName();
            }
        });
    }
}

