/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files.loading;

import com.google.gson.Gson;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.loading.FileLoaderRegistry;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileLoaderRegistryString<S>
extends FileLoaderRegistry<S> {
    public Reader<? extends S> reader;

    public FileLoaderRegistryString(String suffix, LeveledRegistry<? super S> registry, Reader<? extends S> reader) {
        super(suffix, registry);
        this.reader = reader;
    }

    public FileLoaderRegistryString(String suffix, LeveledRegistry<? super S> registry, Gson gson, Class<? extends S> type) {
        this(suffix, registry, FileLoaderRegistryString.gsonReader(gson, type));
    }

    public FileLoaderRegistryString(String suffix, LeveledRegistry<? super S> registry, Class<? extends S> type) {
        this(suffix, registry, FileLoaderRegistryString.gsonReader(type));
    }

    public static <S> Reader<S> gsonReader(Gson gson, Class<? extends S> type) {
        return s -> gson.fromJson(s, type);
    }

    public static <S> Reader<S> gsonReader(Class<? extends S> type) {
        return FileLoaderRegistryString.gsonReader(new Gson(), type);
    }

    @Override
    public S read(Path path, String name) {
        String resource = null;
        try {
            resource = new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            RecurrentComplex.logger.warn("Resource is damaged: " + name, (Throwable)e);
        }
        if (resource == null) {
            return null;
        }
        try {
            return this.read(resource);
        }
        catch (Exception e) {
            RecurrentComplex.logger.warn("Error reading resource: " + name, (Throwable)e);
            return null;
        }
    }

    public S read(String file) throws Exception {
        return this.reader.read(file);
    }

    public static interface Reader<S> {
        public S read(String var1) throws Exception;
    }
}

