/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.utils.RCStructureBoundingBoxes;
import ivorius.reccomplex.utils.accessor.SafeReflector;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HeightMapFreezer {
    protected static Method relightBlock;
    protected static Method propagateSkylightOcclusion;
    protected StructureBoundingBox boundingBox;
    protected World world;
    protected ChunkPos chunkMin;
    protected int[] chunkSize;
    protected TIntObjectMap<Entry> chunks = new TIntObjectHashMap();

    public HeightMapFreezer(StructureBoundingBox boundingBox, World world) {
        this.boundingBox = new StructureBoundingBox(boundingBox.field_78897_a, boundingBox.field_78895_b, boundingBox.field_78896_c, boundingBox.field_78893_d, boundingBox.field_78895_b, boundingBox.field_78892_f);
        this.world = world;
        this.chunkMin = new ChunkPos(StructureBoundingBoxes.min(boundingBox));
        ChunkPos chunkMax = new ChunkPos(StructureBoundingBoxes.max(boundingBox));
        this.chunkSize = new int[]{chunkMax.field_77276_a - this.chunkMin.field_77276_a + 1, chunkMax.field_77275_b - this.chunkMin.field_77275_b + 1};
    }

    public static HeightMapFreezer freeze(StructureBoundingBox boundingBox, World world) {
        HeightMapFreezer freezer = new HeightMapFreezer(boundingBox, world);
        freezer.initialize();
        return freezer;
    }

    protected void initialize() {
        for (ChunkPos pos2 : RCStructureBoundingBoxes.rasterize(this.boundingBox, false)) {
            this.chunks.put(this.index(pos2).intValue(), (Object)new Entry(this.world.func_72964_e(pos2.field_77276_a, pos2.field_77275_b)));
        }
        RCStructureBoundingBoxes.streamMutablePositions(this.boundingBox).forEach(pos -> {
            this.entry((BlockPos)pos).chunk.func_177445_q()[this.chunkSurfaceIndex((BlockPos)pos)] = this.world.func_72800_K() + 1;
        });
    }

    private Entry entry(BlockPos pos) {
        if (pos.func_177958_n() >= this.boundingBox.field_78897_a && pos.func_177952_p() >= this.boundingBox.field_78896_c && pos.func_177958_n() <= this.boundingBox.field_78893_d && pos.func_177952_p() <= this.boundingBox.field_78892_f) {
            return (Entry)this.chunks.get(this.index(new ChunkPos(pos)).intValue());
        }
        return null;
    }

    private Integer index(ChunkPos pos) {
        return (pos.field_77276_a - this.chunkMin.field_77276_a) * this.chunkSize[1] + (pos.field_77275_b - this.chunkMin.field_77275_b);
    }

    private int chunkSurfaceIndex(BlockPos pos) {
        int i = pos.func_177958_n() & 0xF;
        int k = pos.func_177952_p() & 0xF;
        return k << 4 | i;
    }

    public void setBlockState(BlockPos pos, IBlockState state, int flags) {
        this.world.func_180501_a(pos, state, flags);
        this.markBlock(pos, state);
    }

    public void markBlock(BlockPos pos, IBlockState state) {
        Entry entry = this.entry(pos);
        if (entry != null) {
            int light = state.getLightOpacity((IBlockAccess)this.world, pos);
            int surfaceIndex = this.chunkSurfaceIndex(pos);
            if (light > 0 && pos.func_177956_o() >= entry.heightMap[surfaceIndex]) {
                entry.heightMap[surfaceIndex] = pos.func_177956_o();
            }
        }
    }

    public void melt() {
        if (relightBlock == null) {
            relightBlock = ReflectionHelper.findMethod(Chunk.class, (String)"relightBlock", (String)"func_76615_h", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        }
        if (propagateSkylightOcclusion == null) {
            propagateSkylightOcclusion = ReflectionHelper.findMethod(Chunk.class, (String)"propagateSkylightOcclusion", (String)"func_76595_e", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        }
        RCStructureBoundingBoxes.streamMutablePositions(this.boundingBox).forEach(pos -> {
            Entry entry = this.entry((BlockPos)pos);
            int surfaceIndex = this.chunkSurfaceIndex((BlockPos)pos);
            entry.chunk.func_177445_q()[surfaceIndex] = entry.original[surfaceIndex];
        });
        RCStructureBoundingBoxes.streamMutablePositions(this.boundingBox).forEach(pos -> {
            Entry entry = this.entry((BlockPos)pos);
            int surfaceIndex = this.chunkSurfaceIndex((BlockPos)pos);
            if (entry.heightMap[surfaceIndex] >= entry.original[surfaceIndex]) {
                SafeReflector.invoke(entry.chunk, relightBlock, null, pos.func_177958_n() & 0xF, entry.heightMap[surfaceIndex] + 1, pos.func_177952_p() & 0xF);
                SafeReflector.invoke(entry.chunk, propagateSkylightOcclusion, null, pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
                if (this.world.field_73011_w.func_191066_m()) {
                    this.world.func_175664_x(new BlockPos(pos.func_177958_n(), entry.heightMap[surfaceIndex], pos.func_177952_p()));
                }
            }
        });
    }

    private class Entry {
        public Chunk chunk;
        public int[] heightMap;
        public int[] original;

        public Entry(Chunk chunk) {
            this.chunk = chunk;
            this.original = (int[])chunk.func_177445_q().clone();
            this.heightMap = new int[this.original.length];
            Arrays.fill(this.heightMap, -1);
        }
    }
}

